/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.filter;

import com.icthh.xm.commons.domainevent.config.ApiMaskRule;
import com.icthh.xm.commons.domainevent.config.XmDomainEventConfiguration;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.HttpDomainEventPayload;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventSource;
import com.icthh.xm.commons.domainevent.service.filter.DomainEventProvider;
import com.icthh.xm.commons.domainevent.utils.HttpContentUtils;
import com.icthh.xm.commons.domainevent.utils.JsonUtil;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerMapping;

public class DomainEventProviderImpl
implements DomainEventProvider {
    private static final Logger log = LoggerFactory.getLogger(DomainEventProviderImpl.class);
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final String appName;
    private final XmDomainEventConfiguration xmDomainEventConfiguration;
    private final List<ApiMaskRule> maskRules;

    @Override
    public DomainEvent createEvent(HttpServletRequest request, HttpServletResponse response, String tenant, String clientId, String userKey, String[] aggregateDetails, String responseBody) {
        String requestBody = HttpContentUtils.getRequestContent(request);
        return DomainEvent.builder().id(UUID.randomUUID()).txId(MdcUtils.getRid()).aggregateId(JsonUtil.AggregateMapper.getId(aggregateDetails)).aggregateName(JsonUtil.AggregateMapper.getName(aggregateDetails)).aggregateType(JsonUtil.AggregateMapper.getTypeKey(aggregateDetails)).operation(this.xmDomainEventConfiguration.getOperationMapping(tenant, request.getMethod(), request.getRequestURI())).msName(this.appName).source(DefaultDomainEventSource.WEB.getCode()).userKey(userKey).clientId(clientId).tenant(tenant).payload(this.createPayload(tenant, request, response, requestBody, responseBody)).build();
    }

    private HttpDomainEventPayload createPayload(String tenant, HttpServletRequest request, HttpServletResponse response, String requestBody, String responseBody) {
        Set<String> tenantHeaders = this.xmDomainEventConfiguration.getTenantHeaders(tenant);
        HttpDomainEventPayload payload = new HttpDomainEventPayload();
        payload.setMethod(request.getMethod());
        payload.setUrl(request.getRequestURI());
        payload.setUrlPattern(String.valueOf(request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)));
        payload.setUrlPathParams(this.extractPathParams(request));
        payload.setQueryString(request.getQueryString());
        payload.setRequestLength(request.getContentLengthLong());
        payload.setRequestBody(this.maskContent(requestBody, request.getRequestURI(), true, request.getMethod()));
        payload.setResponseBody(this.maskContent(responseBody, request.getRequestURI(), false, request.getMethod()));
        payload.setResponseLength(Long.valueOf(responseBody.length()));
        payload.setRequestHeaders(HttpContentUtils.getRequestHeaders(request, tenantHeaders));
        payload.setResponseHeaders(HttpContentUtils.getResponseHeaders(response, tenantHeaders));
        payload.setResponseCode(response.getStatus());
        payload.setExecTime(MdcUtils.getExecTimeMs());
        return payload;
    }

    private Map<String, Object> extractPathParams(HttpServletRequest request) {
        Object params = request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (params instanceof Map) {
            return (Map)params;
        }
        return null;
    }

    private String maskContent(String content, String uri, boolean request, String httpMethod) {
        if (CollectionUtils.isEmpty(this.maskRules) || StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        return this.maskRules.stream().filter(rule -> (request && rule.isMaskRequest() || !request && rule.isMaskResponse()) && this.matcher.match(rule.getEndpointToMask(), uri) && rule.getHttpMethod().stream().anyMatch(method -> StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)httpMethod))).filter(it -> CollectionUtils.isNotEmpty(it.getPathToMask())).map(rule -> this.applyMask(content, (ApiMaskRule)rule)).findAny().orElse(content);
    }

    private String applyMask(String content, ApiMaskRule rule) {
        DocumentContext documentContext = JsonPath.parse((String)content);
        boolean isChanged = false;
        for (String path : rule.getPathToMask()) {
            try {
                documentContext.set(path, (Object)rule.getMask(), new Predicate[0]);
                isChanged = true;
            }
            catch (PathNotFoundException e) {
                log.warn("Path {} not found, when masking content data", (Object)path);
            }
            catch (Exception e) {
                log.error("Failed to mask content data", (Throwable)e);
            }
        }
        if (!isChanged) {
            return content;
        }
        return documentContext.jsonString();
    }

    public DomainEventProviderImpl(String appName, XmDomainEventConfiguration xmDomainEventConfiguration, List<ApiMaskRule> maskRules) {
        this.appName = appName;
        this.xmDomainEventConfiguration = xmDomainEventConfiguration;
        this.maskRules = maskRules;
    }
}

