/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.filter;

import com.fasterxml.jackson.core.JsonFactory;
import com.icthh.xm.commons.domainevent.config.FilterConfig;
import com.icthh.xm.commons.domainevent.config.XmDomainEventConfiguration;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.service.filter.lep.WebLepFilter;
import com.icthh.xm.commons.domainevent.utils.HttpContentUtils;
import com.icthh.xm.commons.domainevent.utils.JsonUtil;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
public class WebFilterEngine {
    private static final Logger log = LoggerFactory.getLogger(WebFilterEngine.class);
    private static final String EXCLUDE = "exclude";
    private static final String INCLUDE = "include";
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final List<String> ignoredPatterns;
    private final List<String> ignoredHttpMethods;
    private final XmDomainEventConfiguration xmDomainEventConfiguration;
    private final WebLepFilter webLepFilter;
    private final JsonFactory jFactory;
    private final boolean isApplicationLevelFilter;

    public WebFilterEngine(@Value(value="${application.tenant-ignored-path-list:#{T(java.util.Collections).emptyList()}}") List<String> ignoredPatterns, @Value(value="${application.timeline-ignored-http-methods:#{T(java.util.Collections).emptyList()}}") List<String> ignoredHttpMethods, XmDomainEventConfiguration xmDomainEventConfiguration, WebLepFilter webLepFilter) {
        this.ignoredPatterns = ignoredPatterns;
        this.ignoredHttpMethods = ignoredHttpMethods;
        this.xmDomainEventConfiguration = xmDomainEventConfiguration;
        this.webLepFilter = webLepFilter;
        this.isApplicationLevelFilter = this.isApplicationFilterEnabled(ignoredPatterns, ignoredHttpMethods);
        this.jFactory = new JsonFactory();
    }

    public DomainEvent isIgnoreRequest(HttpServletRequest request, HttpServletResponse response, String tenant, BiFunction<String[], String, DomainEvent> domainEventFactory) {
        List<FilterConfig> filterListByTenant = this.xmDomainEventConfiguration.getFilterListByTenant(tenant);
        if (this.isApplicationLevelFilter && filterListByTenant.isEmpty() && this.isApplicationLevelFilterRequest(request)) {
            return null;
        }
        String responseBody = HttpContentUtils.getResponseContent(response);
        String[] values = JsonUtil.extractIdAndTypeKey(this.jFactory, responseBody);
        String aggregationType = JsonUtil.AggregateMapper.getTypeKey(values);
        FilterConfig filterConfig = filterListByTenant.stream().filter(this.getHttpOperationPredicate(request.getMethod())).filter(this.getResponseCodePredicate(response.getStatus())).filter(this.getAggregationTypePredicate(aggregationType)).filter(this.getRequestUrlPredicate(request.getRequestURI())).findAny().orElse(null);
        if (filterConfig == null || EXCLUDE.equals(filterConfig.getFilterType())) {
            return null;
        }
        DomainEvent domainEvent = domainEventFactory.apply(values, responseBody);
        boolean isLepFiltering = this.webLepFilter.lepFiltering(filterConfig.getKey(), domainEvent);
        if (!isLepFiltering) {
            return null;
        }
        return domainEvent;
    }

    private Predicate<FilterConfig> getAggregationTypePredicate(String aggregationType) {
        return config -> {
            if (config.getAggregateType() == null) {
                return true;
            }
            if (config.getAggregateType().isEmpty()) {
                return false;
            }
            return config.getAggregateType().contains(aggregationType);
        };
    }

    private Predicate<FilterConfig> getRequestUrlPredicate(String requestUrl) {
        return config -> {
            if (StringUtils.isEmpty((CharSequence)config.getUrlPattern())) {
                return true;
            }
            if ("*".equals(config.getUrlPattern())) {
                return true;
            }
            return this.matcher.match(config.getUrlPattern(), requestUrl);
        };
    }

    private Predicate<FilterConfig> getHttpOperationPredicate(String httpOperation) {
        return config -> {
            if (config.getHttpOperation() == null) {
                return true;
            }
            if (config.getHttpOperation().isEmpty()) {
                return false;
            }
            return config.getHttpOperation().contains(httpOperation);
        };
    }

    private Predicate<FilterConfig> getResponseCodePredicate(int responseCode) {
        return config -> {
            if (config.getResponseCode() == null) {
                return true;
            }
            if (config.getResponseCode().isEmpty()) {
                return false;
            }
            return config.getResponseCode().contains(responseCode);
        };
    }

    private boolean isApplicationFilterEnabled(List<String> ignoredPatterns, List<String> ignoredHttpMethods) {
        return CollectionUtils.isEmpty(ignoredPatterns) || CollectionUtils.isEmpty(ignoredHttpMethods);
    }

    private boolean isApplicationLevelFilterRequest(HttpServletRequest request) {
        String path = request.getServletPath();
        String httpMethod = request.getMethod();
        if (CollectionUtils.isNotEmpty(this.ignoredHttpMethods) && this.ignoredHttpMethods.contains(httpMethod)) {
            return true;
        }
        if (this.ignoredPatterns != null && path != null) {
            for (String pattern : this.ignoredPatterns) {
                if (!this.matcher.match(pattern, path)) continue;
                return true;
            }
        }
        return false;
    }
}

