/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final String ID_FIELD_NAME = "id";
    private static final String TYPE_KEY_FIELD_NAME = "typeKey";
    private static final String NAME_FIELD_NAME = "name";
    private static final int FIELD_COUNT = 3;
    public static final int ID = 0;
    public static final int TYPE_KEY = 1;
    public static final int NAME = 2;

    public static String[] extractIdAndTypeKey(JsonFactory jsonFactory, String json) {
        String[] values = new String[3];
        if (json == null) {
            return values;
        }
        try (JsonParser jParser = jsonFactory.createParser(json);){
            while (jParser.nextToken() != JsonToken.END_OBJECT && !jParser.isClosed()) {
                String fieldName = jParser.getCurrentName();
                if (fieldName == null) continue;
                if (ID_FIELD_NAME.equals(fieldName)) {
                    jParser.nextToken();
                    values[0] = jParser.getText();
                    continue;
                }
                if (TYPE_KEY_FIELD_NAME.equals(fieldName)) {
                    jParser.nextToken();
                    values[1] = jParser.getText();
                    continue;
                }
                if (NAME_FIELD_NAME.equals(fieldName)) {
                    jParser.nextToken();
                    values[2] = jParser.getText();
                    continue;
                }
                if ("xmEntity".equals(fieldName)) {
                    JsonUtil.extractFromInnerLevel(jParser, values);
                }
                if (!"data".equals(fieldName)) continue;
                JsonUtil.extractFromInnerLevel(jParser, values);
            }
        }
        catch (IOException e) {
            log.trace(e.getMessage(), (Throwable)e);
        }
        return values;
    }

    private static void extractFromInnerLevel(JsonParser jParser, String[] result) {
        jParser.nextToken();
        while (jParser.nextToken() != JsonToken.END_OBJECT) {
            String innerFieldName = jParser.getCurrentName();
            if (result[0] == null && ID_FIELD_NAME.equals(innerFieldName)) {
                jParser.nextToken();
                result[0] = jParser.getText();
                continue;
            }
            if (result[1] == null && TYPE_KEY_FIELD_NAME.equals(innerFieldName)) {
                jParser.nextToken();
                result[1] = jParser.getText();
                continue;
            }
            if (result[2] != null || !NAME_FIELD_NAME.equals(innerFieldName)) continue;
            jParser.nextToken();
            result[2] = jParser.getText();
        }
    }

    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class AggregateMapper {
        public static String getTypeKey(String[] values) {
            return values[1];
        }

        public static String getId(String[] values) {
            return values[0];
        }

        public static String getName(String[] values) {
            return values[2];
        }
    }
}

