/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.config;

import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventSource;
import com.icthh.xm.commons.domainevent.service.EventPublisher;
import com.icthh.xm.commons.domainevent.service.filter.DomainEventProvider;
import com.icthh.xm.commons.domainevent.service.filter.DomainEventProviderFactory;
import com.icthh.xm.commons.domainevent.service.filter.WebFilterEngine;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

@Component
@ConditionalOnProperty(value={"application.domain-event.enabled"}, havingValue="true")
public class WebApiSource
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebApiSource.class);
    private static final String HEADER_TENANT = "x-tenant";
    private final EventPublisher eventPublisher;
    private final XmAuthenticationContextHolder xmAuthenticationContextHolder;
    private final DomainEventProvider domainEventProvider;
    private final WebFilterEngine webFilterEngine;

    public WebApiSource(EventPublisher eventPublisher, XmAuthenticationContextHolder xmAuthenticationContextHolder, WebFilterEngine webFilterEngine, DomainEventProviderFactory domainEventProviderFactory) {
        this.eventPublisher = eventPublisher;
        this.xmAuthenticationContextHolder = xmAuthenticationContextHolder;
        this.webFilterEngine = webFilterEngine;
        this.domainEventProvider = domainEventProviderFactory.newDomainEventProvider();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        XmAuthenticationContext auth = this.xmAuthenticationContextHolder.getContext();
        if (auth == null || auth.isAnonymous()) {
            String tenant = request.getHeader(HEADER_TENANT);
            this.publishEvent(request, response, tenant, null, null);
        } else {
            String clientId = auth.getClientId().orElse("");
            String userKey = auth.getUserKey().orElse("");
            String tenant = auth.getTenantName().orElse("");
            this.publishEvent(request, response, tenant, clientId, userKey);
        }
    }

    private void publishEvent(HttpServletRequest request, HttpServletResponse response, String tenant, String clientId, String userKey) {
        DomainEvent domainEvent = this.webFilterEngine.isIgnoreRequest(request, response, tenant, (aggregateDetails, responseBody) -> this.domainEventProvider.createEvent(request, response, tenant, clientId, userKey, (String[])aggregateDetails, (String)responseBody));
        if (domainEvent == null) {
            return;
        }
        this.eventPublisher.publish(DefaultDomainEventSource.WEB.getCode(), domainEvent);
    }
}

