/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.domainevent.config.DbSourceConfig;
import com.icthh.xm.commons.domainevent.config.EventPublisherConfig;
import com.icthh.xm.commons.domainevent.config.FilterConfig;
import com.icthh.xm.commons.domainevent.config.SourceConfig;
import com.icthh.xm.commons.domainevent.config.TransformMappingConfig;
import com.icthh.xm.commons.domainevent.config.WebSourceConfig;
import com.icthh.xm.commons.domainevent.config.event.InitSourceEventPublisher;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventSource;
import com.icthh.xm.commons.domainevent.service.Transport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class XmDomainEventConfiguration
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XmDomainEventConfiguration.class);
    private static final String TENANT_NAME = "tenant";
    private static final EventPublisherConfig DEFAULT_EVENT_PUBLISHER_CONFIG = new EventPublisherConfig();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final InitSourceEventPublisher initSourceEventPublisher;
    private final ApplicationContext applicationContext;
    private final String configPath;
    private final Map<String, EventPublisherConfig> configByTenant = new HashMap<String, EventPublisherConfig>();
    private final Map<String, Map<String, Transport>> transportBySource = new HashMap<String, Map<String, Transport>>();
    private final ConcurrentHashMap<String, List<TransformMappingConfig>> operationMappingByTenant = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<FilterConfig>> filterListByTenant = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> headersSetByTenant = new ConcurrentHashMap();

    public XmDomainEventConfiguration(@Value(value="${spring.application.name}") String appName, InitSourceEventPublisher initSourceEventPublisher, ApplicationContext applicationContext) {
        this.configPath = "/config/tenants/{tenant}/" + appName + "/domainevent.yml";
        this.initSourceEventPublisher = initSourceEventPublisher;
        this.applicationContext = applicationContext;
    }

    public DbSourceConfig getDbSourceConfig(String tenantKey, String source) {
        DbSourceConfig dbSourceConfig = null;
        SourceConfig sourceConfig = this.getEventPublisherConfig(tenantKey).getSources().get(source);
        if (sourceConfig instanceof DbSourceConfig) {
            dbSourceConfig = (DbSourceConfig)sourceConfig;
        }
        return dbSourceConfig;
    }

    public WebSourceConfig getWebSourceConfig(String tenantKey, String source) {
        WebSourceConfig webSourceConfig = null;
        SourceConfig sourceConfig = this.getEventPublisherConfig(tenantKey).getSources().get(source);
        if (sourceConfig instanceof WebSourceConfig) {
            webSourceConfig = (WebSourceConfig)sourceConfig;
        }
        return webSourceConfig;
    }

    public Transport getTransport(String tenantKey, String source) {
        Objects.requireNonNull(tenantKey, "Tenant key does not exists!");
        return Optional.ofNullable(this.transportBySource.get(tenantKey)).map(sourceTransportMap -> (Transport)sourceTransportMap.get(source)).orElseThrow(() -> new IllegalStateException(String.format("Transport is not configured for tenant: %s and source: %s", tenantKey, source)));
    }

    private EventPublisherConfig getEventPublisherConfig(String tenantKey) {
        return this.configByTenant.getOrDefault(tenantKey, DEFAULT_EVENT_PUBLISHER_CONFIG);
    }

    public void onRefresh(String updatedKey, String config) {
        this.setConfig(updatedKey, config);
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.configPath, updatedKey);
    }

    public void onInit(String configKey, String configValue) {
        if (this.isListeningConfiguration(configKey)) {
            this.setConfig(configKey, configValue);
        }
    }

    private void setConfig(String updatedKey, String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            return;
        }
        String tenantKey = this.extractTenant(updatedKey);
        this.configByTenant.remove(tenantKey);
        EventPublisherConfig eventPublisherConfig = this.readConfig(updatedKey, config);
        if (eventPublisherConfig != null && eventPublisherConfig.isEnabled()) {
            Set<String> sourceConfigHeaders;
            List<FilterConfig> filter;
            this.configByTenant.put(tenantKey, eventPublisherConfig);
            Map<String, SourceConfig> sources = eventPublisherConfig.getSources();
            this.initTransportSourceMap(tenantKey, sources);
            this.initSourceEventPublisher.publish(tenantKey, sources.values());
            WebSourceConfig sourceConfig = this.getWebSourceConfig(tenantKey, DefaultDomainEventSource.WEB.getCode());
            if (sourceConfig == null || !sourceConfig.isEnabled()) {
                return;
            }
            List<TransformMappingConfig> transformMappingConfigs = sourceConfig.getTransform();
            if (CollectionUtils.isNotEmpty(transformMappingConfigs)) {
                this.operationMappingByTenant.put(tenantKey, transformMappingConfigs);
            }
            if (CollectionUtils.isNotEmpty(filter = sourceConfig.getFilter())) {
                this.filterListByTenant.put(tenantKey, filter);
            }
            if (CollectionUtils.isNotEmpty(sourceConfigHeaders = sourceConfig.getHeaders())) {
                this.headersSetByTenant.put(tenantKey, sourceConfigHeaders);
            }
        }
    }

    private void initTransportSourceMap(String tenantKey, Map<String, SourceConfig> sourceConfigMap) {
        HashMap sourceTransportMap = new HashMap();
        this.transportBySource.put(tenantKey, sourceTransportMap);
        sourceConfigMap.forEach((s, sourceConfig) -> {
            if (sourceConfig.isEnabled()) {
                sourceTransportMap.put(s, (Transport)this.applicationContext.getBean(sourceConfig.getTransport(), Transport.class));
            }
        });
    }

    private String extractTenant(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(this.configPath, updatedKey).get(TENANT_NAME);
    }

    private EventPublisherConfig readConfig(String updatedKey, String config) {
        EventPublisherConfig publisherConfig = null;
        try {
            publisherConfig = (EventPublisherConfig)this.ymlMapper.readValue(config, EventPublisherConfig.class);
        }
        catch (Exception e) {
            log.error("Error reading event publisher config from path: {}", (Object)updatedKey, (Object)e);
        }
        return publisherConfig;
    }

    public List<FilterConfig> getFilterListByTenant(String tenantKey) {
        return this.filterListByTenant.getOrDefault(tenantKey, List.of());
    }

    public Set<String> getTenantHeaders(String tenantKey) {
        return this.headersSetByTenant.getOrDefault(tenantKey, Set.of());
    }

    public String getOperationMapping(String tenantKey, String method, String url) {
        List transformMappingConfigs = this.operationMappingByTenant.getOrDefault(tenantKey, List.of());
        return this.getOperationByUrl(method, transformMappingConfigs.stream(), url);
    }

    private String getOperationByUrl(String method, Stream<TransformMappingConfig> transformMappingConfigs, String url) {
        switch (method) {
            case "GET": {
                return this.getOperationName(url, transformMappingConfigs.filter(this.createOperationPredicate("GET")), "viewed");
            }
            case "POST": {
                return this.getOperationName(url, transformMappingConfigs.filter(this.createOperationPredicate("POST")), "created");
            }
            case "PUT": {
                return this.getOperationName(url, transformMappingConfigs.filter(this.createOperationPredicate("PUT")), "changed");
            }
            case "DELETE": {
                return this.getOperationName(url, transformMappingConfigs.filter(this.createOperationPredicate("DELETE")), "deleted");
            }
        }
        return "";
    }

    private Predicate<TransformMappingConfig> createOperationPredicate(String operationName) {
        return transformMappingConfig -> transformMappingConfig.getHttpOperation().contains(operationName);
    }

    private String getOperationName(String url, Stream<TransformMappingConfig> transformMappingConfigs, String defaultValue) {
        return transformMappingConfigs.filter(it -> this.matcher.match(it.getUrlPattern(), url)).findFirst().map(it -> this.fillTemplate(url, (TransformMappingConfig)it)).orElse(this.getDefaultOperation(url, defaultValue));
    }

    private String fillTemplate(String url, TransformMappingConfig it) {
        String operationText = it.getOperationName();
        Map variables = this.matcher.extractUriTemplateVariables(it.getUrlPattern(), url);
        for (Map.Entry e : variables.entrySet()) {
            operationText = operationText.replace("{" + (String)e.getKey() + "}", (CharSequence)e.getValue());
        }
        return operationText;
    }

    private String getDefaultOperation(String url, String defaultValue) {
        return this.getResourceName(url) + " " + defaultValue;
    }

    private String getResourceName(String path) {
        String name = StringUtils.removeStart((String)path, (String)"/api/");
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)"_search")) {
            name = StringUtils.substringAfter((String)name, (String)"/");
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.substringBefore((String)name, (String)"/"), (CharSequence)"unknown");
    }

    static {
        DEFAULT_EVENT_PUBLISHER_CONFIG.setEnabled(false);
        DEFAULT_EVENT_PUBLISHER_CONFIG.setSources(Map.of());
    }
}

