/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service;

import com.icthh.xm.commons.domainevent.config.XmDomainEventConfiguration;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.service.Transport;
import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.logging.LoggingAspectConfig;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@LepService(group="event.publisher")
public class EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventPublisher.class);
    private final XmDomainEventConfiguration xmDomainEventConfiguration;
    private final TenantContextHolder tenantContextHolder;

    @LoggingAspectConfig(inputExcludeParams={"event"})
    @LogicExtensionPoint(value="Publish")
    public void publish(String source, DomainEvent event) {
        event.setSource(source);
        Transport transportToPublish = this.xmDomainEventConfiguration.getTransport(this.tenantContextHolder.getTenantKey(), source);
        transportToPublish.send(event);
    }

    public EventPublisher(XmDomainEventConfiguration xmDomainEventConfiguration, TenantContextHolder tenantContextHolder) {
        this.xmDomainEventConfiguration = xmDomainEventConfiguration;
        this.tenantContextHolder = tenantContextHolder;
    }
}

