/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.builder;

import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.domain.DomainEventPayload;
import com.icthh.xm.commons.domainevent.domain.enums.DefaultDomainEventOperation;
import com.icthh.xm.commons.domainevent.service.builder.DomainEventBuilder;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DomainEventFactory {
    private final DomainEventBuilder domainEventBuilder;
    private Optional<DomainEventBuilder> transactionalDomainEventBuilder;

    @Autowired
    public DomainEventFactory(@Qualifier(value="defaultDomainEventBuilder") DomainEventBuilder defaultDomainEventBuilder, @Qualifier(value="txDomainEventBuilder") Optional<DomainEventBuilder> transactionalDomainEventBuilder) {
        this.transactionalDomainEventBuilder = transactionalDomainEventBuilder;
        this.domainEventBuilder = defaultDomainEventBuilder;
    }

    private DomainEventFactory(DomainEventBuilder domainEventBuilder) {
        this.domainEventBuilder = domainEventBuilder;
    }

    public DomainEventFactory withTransaction() {
        DomainEventBuilder txDomainEventBuilder = this.transactionalDomainEventBuilder.orElseThrow(() -> new NotImplementedException("Transactional domain event builder is not implemented. No txDomainEventBuilder bean in scope."));
        return new DomainEventFactory(txDomainEventBuilder);
    }

    public DomainEvent.DomainEventBuilder builder() {
        return this.domainEventBuilder.getPrefilledBuilder();
    }

    public DomainEvent build() {
        return this.domainEventBuilder.getPrefilledBuilder().build();
    }

    public DomainEvent build(DomainEventPayload payload) {
        return this.builder().payload(payload).build();
    }

    public DomainEvent build(DefaultDomainEventOperation operation) {
        return this.builder().operation(operation == null ? null : operation.toString()).build();
    }

    public DomainEvent build(DefaultDomainEventOperation operation, String aggregateId, String aggregateType) {
        return this.builder().aggregateId(aggregateId).aggregateType(aggregateType).operation(operation == null ? null : operation.toString()).build();
    }

    public DomainEvent build(DefaultDomainEventOperation operation, UUID id, String aggregateId, String aggregateType, DomainEventPayload payload) {
        return this.builder().id(id).aggregateId(aggregateId).aggregateType(aggregateType).operation(operation == null ? null : operation.toString()).payload(payload).build();
    }
}

