/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.builder.impl;

import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.service.builder.DomainEventBuilder;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultDomainEventBuilder")
public class DefaultDomainEventBuilder
implements DomainEventBuilder {
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder xmAuthenticationContextHolder;
    @Value(value="${spring.application.name}")
    private String msName;

    @Override
    public DomainEvent.DomainEventBuilder getPrefilledBuilder() {
        XmAuthenticationContext context = this.xmAuthenticationContextHolder.getContext();
        return DomainEvent.builder().msName(this.msName).tenant(this.tenantContextHolder.getTenantKey()).eventDate(Instant.now()).clientId(context == null ? null : (String)context.getClientId().orElse(null)).userKey(context == null ? null : (String)context.getUserKey().orElse(null));
    }

    public DefaultDomainEventBuilder(TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder xmAuthenticationContextHolder) {
        this.tenantContextHolder = tenantContextHolder;
        this.xmAuthenticationContextHolder = xmAuthenticationContextHolder;
    }
}

