/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.filter;

import com.icthh.xm.commons.domainevent.config.ApiMaskConfig;
import com.icthh.xm.commons.domainevent.config.ApiMaskRule;
import com.icthh.xm.commons.domainevent.config.XmDomainEventConfiguration;
import com.icthh.xm.commons.domainevent.service.filter.DomainEventProvider;
import com.icthh.xm.commons.domainevent.service.filter.DomainEventProviderImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"application.domain-event.enabled"}, havingValue="true")
public class DomainEventProviderFactory {
    @Value(value="${spring.application.name}")
    private String appName;
    private final XmDomainEventConfiguration xmDomainEventConfiguration;
    private final ApiMaskConfig apiIgnore;

    public DomainEventProvider newDomainEventProvider() {
        List<ApiMaskRule> maskRules = this.apiIgnore != null ? this.apiIgnore.getMaskRules() : null;
        return new DomainEventProviderImpl(this.appName, this.xmDomainEventConfiguration, maskRules);
    }

    public DomainEventProviderFactory(XmDomainEventConfiguration xmDomainEventConfiguration, ApiMaskConfig apiIgnore) {
        this.xmDomainEventConfiguration = xmDomainEventConfiguration;
        this.apiIgnore = apiIgnore;
    }
}

