/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.impl;

import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
@Scope(value="transaction")
public class KafkaTransactionSynchronizationAdapter {
    private static final Logger log = LoggerFactory.getLogger(KafkaTransactionSynchronizationAdapter.class);
    private final List<DomainEvent> eventList = new ArrayList<DomainEvent>();

    public void send(DomainEvent event, final Consumer<DomainEvent> kafkaTransport) {
        if (this.eventList.isEmpty()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    super.afterCompletion(status);
                    if (status == 0) {
                        try {
                            if (!KafkaTransactionSynchronizationAdapter.this.eventList.isEmpty()) {
                                KafkaTransactionSynchronizationAdapter.this.eventList.forEach(kafkaTransport);
                                log.debug("Inserted {} items to kafka", (Object)KafkaTransactionSynchronizationAdapter.this.eventList.size());
                            }
                        }
                        catch (Exception e) {
                            log.error("Error in afterCompletion stage during transaction synchronization for entity: {}", KafkaTransactionSynchronizationAdapter.this.eventList, (Object)e);
                        }
                    }
                    KafkaTransactionSynchronizationAdapter.this.eventList.clear();
                }
            });
        }
        this.eventList.add(event);
    }
}

