/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.domainevent.domain.DomainEvent;
import com.icthh.xm.commons.domainevent.service.Transport;
import com.icthh.xm.commons.domainevent.service.impl.KafkaTransactionSynchronizationAdapterService;
import com.icthh.xm.commons.logging.LoggingAspectConfig;
import com.icthh.xm.commons.topic.service.KafkaTemplateService;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class SyncKafkaTransport
implements Transport {
    private static final Logger log = LoggerFactory.getLogger(SyncKafkaTransport.class);
    private static final String TOPIC_FORMAT = "event.%s.%s";
    private final KafkaTemplateService kafkaTemplateService;
    private final ObjectMapper objectMapper;
    private final KafkaTransactionSynchronizationAdapterService kafkaTransactionSynchronizationAdapterService;

    @Override
    @LoggingAspectConfig(inputDetails=false)
    public void send(DomainEvent event) {
        Consumer<DomainEvent> domainEventConsumer = this.sendMessageConsumer();
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.kafkaTransactionSynchronizationAdapterService.send(event, domainEventConsumer);
            return;
        }
        domainEventConsumer.accept(event);
    }

    private Consumer<DomainEvent> sendMessageConsumer() {
        return domainEvent -> {
            String topic = this.prepareTopicName((DomainEvent)domainEvent);
            String data = this.toJson((DomainEvent)domainEvent);
            this.kafkaTemplateService.send(topic, data);
            log.info("Send event to kafka topic = {}", (Object)topic);
        };
    }

    private String toJson(DomainEvent domainEvent) {
        return this.objectMapper.writeValueAsString((Object)domainEvent);
    }

    private String prepareTopicName(DomainEvent event) {
        if (StringUtils.isBlank((CharSequence)event.getTenant()) || StringUtils.isBlank((CharSequence)event.getSource())) {
            throw new IllegalArgumentException("Empty fields in domain event!");
        }
        return String.format(TOPIC_FORMAT, event.getTenant(), event.getSource()).toLowerCase();
    }

    public SyncKafkaTransport(KafkaTemplateService kafkaTemplateService, ObjectMapper objectMapper, KafkaTransactionSynchronizationAdapterService kafkaTransactionSynchronizationAdapterService) {
        this.kafkaTemplateService = kafkaTemplateService;
        this.objectMapper = objectMapper;
        this.kafkaTransactionSynchronizationAdapterService = kafkaTransactionSynchronizationAdapterService;
    }
}

