/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domainevent.utils;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public final class HttpContentUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpContentUtils.class);

    public static String getResponseContent(HttpServletResponse response) {
        if (response instanceof ContentCachingResponseWrapper) {
            return new String(((ContentCachingResponseWrapper)response).getContentAsByteArray());
        }
        if (response instanceof HttpServletResponseWrapper && ((HttpServletResponseWrapper)response).getResponse() instanceof ContentCachingResponseWrapper) {
            return new String(((ContentCachingResponseWrapper)((HttpServletResponseWrapper)response).getResponse()).getContentAsByteArray());
        }
        log.warn("Empty response content because of unsupported response class {}", (Object)response.getClass());
        return "";
    }

    public static String getRequestContent(HttpServletRequest request) {
        if (request instanceof ContentCachingRequestWrapper) {
            return new String(((ContentCachingRequestWrapper)request).getContentAsByteArray());
        }
        if (request instanceof HttpServletRequestWrapper && ((HttpServletRequestWrapper)request).getRequest() instanceof ContentCachingRequestWrapper) {
            return new String(((ContentCachingRequestWrapper)((HttpServletRequestWrapper)request).getRequest()).getContentAsByteArray());
        }
        log.warn("Empty request content because of unsupported request class {}", (Object)request.getClass());
        return "";
    }

    public static Map<String, List<String>> getRequestHeaders(HttpServletRequest request, Set<String> headerNames) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (headerNames.contains(name.toLowerCase())) continue;
            headers.put(name.toLowerCase(), Collections.list(request.getHeaders(name)));
        }
        HttpContentUtils.removeEmptyHeaders(headers);
        return headers;
    }

    public static Map<String, List<String>> getResponseHeaders(HttpServletResponse httpServletResponse, Set<String> headerNames) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        for (String header : httpServletResponse.getHeaderNames()) {
            if (headerNames.contains(header.toLowerCase())) continue;
            Collection value = httpServletResponse.getHeaders(header);
            headers.put(header.toLowerCase(), new ArrayList(value));
        }
        headers.remove("set-cookie");
        HttpContentUtils.removeEmptyHeaders(headers);
        return headers;
    }

    private static void removeEmptyHeaders(Map<String, List<String>> headers) {
        headers.entrySet().removeIf(it -> CollectionUtils.isEmpty((Collection)((Collection)it.getValue())));
    }

    private HttpContentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

