/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.i18n.spring.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.i18n.spring.config.LocalizationMessageProperties;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenant.TenantKey;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
@IgnoreLogginAspect
public class LocalizationMessageService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalizationMessageService.class);
    private static final String TENANT_NAME = "tenantName";
    private final LocalizationMessageProperties localizationMessageProperties;
    private final MessageSource messageSource;
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder authContextHolder;
    private final ConcurrentHashMap<String, Map<String, Map<Locale, String>>> tenantLocalizedMessageConfig = new ConcurrentHashMap();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public String getMessage(String code, Map<String, String> substitutes, boolean firstFindInMessageBundle, String defaultMessage) {
        Locale locale = this.authContextHolder.getContext().getDetailsValue("language").map(Locale::forLanguageTag).orElse(LocaleContextHolder.getLocale());
        String localizedMessage = this.getFromConfig(code, locale).orElseGet(() -> {
            if (firstFindInMessageBundle) {
                return this.messageSource.getMessage(code, null, defaultMessage, locale);
            }
            return defaultMessage != null ? defaultMessage : this.messageSource.getMessage(code, null, locale);
        });
        if (MapUtils.isNotEmpty(substitutes)) {
            localizedMessage = new StringSubstitutor(substitutes).replace(localizedMessage);
        }
        return localizedMessage;
    }

    public String getMessage(String code) {
        return this.getMessage(code, null, true, null);
    }

    public String getMessage(String code, Map<String, String> substitutes) {
        return this.getMessage(code, substitutes, true, null);
    }

    public void onRefresh(String key, String config) {
        String tenant = (String)this.matcher.extractUriTemplateVariables(this.localizationMessageProperties.getConfigPath(), key).get(TENANT_NAME);
        if (StringUtils.isBlank((CharSequence)config)) {
            this.tenantLocalizedMessageConfig.remove(tenant);
            log.info("Localized error messages for tenant {} was removed", (Object)tenant);
        } else {
            try {
                Map localizedMessages = (Map)this.mapper.readValue(config, (TypeReference)new TypeReference<Map<String, Map<Locale, String>>>(){});
                this.tenantLocalizedMessageConfig.put(tenant, localizedMessages);
                log.info("Localized error messages for tenant {} was updated", (Object)tenant);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading config by path: {}" + key, e);
            }
        }
    }

    public boolean isListeningConfiguration(String key) {
        return this.matcher.match(this.localizationMessageProperties.getConfigPath(), key);
    }

    public void onInit(String configKey, String configValue) {
        this.onRefresh(configKey, configValue);
    }

    private Optional<String> getFromConfig(String messageCode, Locale locale) {
        return TenantContextUtils.getTenantKey((TenantContextHolder)this.tenantContextHolder).map(TenantKey::getValue).map(this.tenantLocalizedMessageConfig::get).map(localizedMessageConfig -> (Map)localizedMessageConfig.get(messageCode)).map(localizedMessages -> (String)localizedMessages.get(locale));
    }

    public LocalizationMessageService(LocalizationMessageProperties localizationMessageProperties, MessageSource messageSource, TenantContextHolder tenantContextHolder, XmAuthenticationContextHolder authContextHolder) {
        this.localizationMessageProperties = localizationMessageProperties;
        this.messageSource = messageSource;
        this.tenantContextHolder = tenantContextHolder;
        this.authContextHolder = authContextHolder;
    }
}

