/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domain.idp;

import com.icthh.xm.commons.domain.idp.model.IdpPrivateConfig;
import com.icthh.xm.commons.domain.idp.model.IdpPublicConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class IdpConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(IdpConfigUtils.class);

    public static boolean isPublicClientConfigValid(IdpPublicConfig.IdpConfigContainer.IdpPublicClientConfig idpPublicClientConfig) {
        if (idpPublicClientConfig == null) {
            log.warn("Public idp config not specified.");
            return false;
        }
        if (idpPublicClientConfig.getKey() == null) {
            log.warn("Client key not specified in configuration.");
            return false;
        }
        if (idpPublicClientConfig.getRedirectUri() == null) {
            log.warn("Redirect uri not specified in configuration.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getName())) {
            log.warn("Client name not specified in configuration.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getClientId())) {
            log.warn("Client id not specified in configuration.");
            return false;
        }
        if (idpPublicClientConfig.getOpenIdConfig() == null) {
            log.warn("openIdConfig section not specified or have lack of configuration.");
            return false;
        }
        if (idpPublicClientConfig.getOpenIdConfig().getAuthorizationEndpoint() == null || StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getOpenIdConfig().getAuthorizationEndpoint().getUri())) {
            log.warn("Authorization endpoint uri not specified or have lack of configuration.");
            return false;
        }
        if (idpPublicClientConfig.getOpenIdConfig().getTokenEndpoint() == null || StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getOpenIdConfig().getTokenEndpoint().getUri())) {
            log.warn("Token endpoint uri not specified or have lack of configuration.");
            return false;
        }
        if (idpPublicClientConfig.getOpenIdConfig().getUserinfoEndpoint() == null || StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getOpenIdConfig().getUserinfoEndpoint().getUri())) {
            log.warn("User info endpoint uri not specified or have lack of configuration.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getOpenIdConfig().getUserinfoEndpoint().getUserNameAttributeName())) {
            log.warn("User name attribute not specified or have lack of configuration in user info endpoint section.");
            return false;
        }
        if (idpPublicClientConfig.getOpenIdConfig().getJwksEndpoint() == null || StringUtils.isEmpty((CharSequence)idpPublicClientConfig.getOpenIdConfig().getJwksEndpoint().getUri())) {
            log.warn("jwks endpoint uri not specified or have lack of configuration.");
            return false;
        }
        return true;
    }

    public static boolean isTenantFeaturesConfigValid(IdpPublicConfig.IdpConfigContainer.Features features) {
        if (features == null) {
            log.warn("Features section not specified or have lack of configuration.");
            return false;
        }
        IdpPublicConfig.IdpConfigContainer.Features.IdpAccessTokenInclusion idpAccessTokenInclusion = features.getIdpAccessTokenInclusion();
        if (idpAccessTokenInclusion == null) {
            log.warn("features.idpAccessTokenInclusion section not specified.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)idpAccessTokenInclusion.getIdpTokenHeader())) {
            log.warn("features.idpAccessTokenInclusion.idpTokenHeader option not specified.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)idpAccessTokenInclusion.getXmTokenHeader())) {
            log.warn("features.idpAccessTokenInclusion.xmTokenHeader option not specified.");
            return false;
        }
        return true;
    }

    public static boolean isPrivateClientConfigValid(IdpPrivateConfig.IdpConfigContainer.IdpPrivateClientConfig idpPrivateClientConfig) {
        if (idpPrivateClientConfig == null) {
            log.warn("private idp config not specified.");
            return false;
        }
        if (idpPrivateClientConfig.getClientSecret() == null) {
            log.warn("client secret not specified in configuration.");
            return false;
        }
        if (CollectionUtils.isEmpty(idpPrivateClientConfig.getScope())) {
            log.warn("idp scopes not specified in configuration.");
            return false;
        }
        return true;
    }

    private IdpConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

