/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.repository;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

@Component
public class JwksRepository
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JwksRepository.class);
    private static final String KEY_TENANT = "tenant";
    private final Map<String, Map<String, String>> jwksStorage = new ConcurrentHashMap<String, Map<String, String>>();
    private static final String SKIP_MESSAGE_TEMPLATE = "Skipping process file with path [{}]";
    private final TenantContextHolder tenantContextHolder;
    private final AntPathMatcher matcher = new AntPathMatcher();

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match("/config/tenants/{tenant}/config/idp/clients/{idpClientKey}-jwks-cache.json", updatedKey);
    }

    public void onInit(String configKey, String configValue) {
        this.processJwks(configKey, configValue);
    }

    public void onRefresh(String updatedKey, String config) {
        this.processJwks(updatedKey, config);
    }

    private void processJwks(String configPath, String config) {
        String tenantKey = this.extractKeyFromPath(configPath, KEY_TENANT);
        String clientKey = this.extractKeyFromPath(configPath, "idpClientKey");
        if (StringUtils.isEmpty((Object)config)) {
            log.info("config not specified for tenant [{}] with clientKey [{}]. Skipping process file with path [{}]", new Object[]{tenantKey, clientKey, configPath});
            this.deleteInMemoryJwks(tenantKey, clientKey);
            return;
        }
        this.saveJwks(config, tenantKey, clientKey);
    }

    private void saveJwks(String config, String tenantKey, String clientKey) {
        this.jwksStorage.computeIfAbsent(tenantKey, key -> new ConcurrentHashMap()).put(clientKey, config);
    }

    private String extractKeyFromPath(String configPath, String keyName) {
        return (String)this.matcher.extractUriTemplateVariables("/config/tenants/{tenant}/config/idp/clients/{idpClientKey}-jwks-cache.json", configPath).get(keyName);
    }

    public Map<String, String> getTenantIdpJwks() {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        return this.jwksStorage.getOrDefault(tenantKey, new HashMap());
    }

    private void deleteInMemoryJwks(String tenantKey, String clientKey) {
        log.info("Delete in-memory jwks keys for client with key [{}] in [{}] tenant", (Object)clientKey, (Object)tenantKey);
        this.jwksStorage.computeIfPresent(tenantKey, (k, v) -> {
            v.remove(clientKey);
            return v;
        });
    }

    public JwksRepository(TenantContextHolder tenantContextHolder) {
        this.tenantContextHolder = tenantContextHolder;
    }
}

