/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import groovyjarjarantlr.CharScanner;
import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import groovyjarjarantlr.collections.AST;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.antlr.treewalker.Visitor;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyFileParser {
    private static final Logger log = LoggerFactory.getLogger(GroovyFileParser.class);

    public GroovyFileMetadata getFileMetaData(String source) {
        try {
            return this.getGroovyFileMetadata(source);
        }
        catch (Throwable e) {
            log.error("Error parse groovy: {}", (Object)e.getMessage(), (Object)e);
            return new GroovyFileMetadata();
        }
    }

    public GroovyFileMetadata getGroovyFileMetadata(String source) throws TokenStreamException, RecognitionException {
        GroovyFileMetadata metadata = new GroovyFileMetadata();
        this.parseGroovy(source, (Visitor)new GroovyParseVisitor(metadata));
        return metadata;
    }

    private void parseGroovy(String source, Visitor visitor) throws TokenStreamException, RecognitionException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        GroovyRecognizer parser = GroovyFileParser.getGroovyParser(source, sourceBuffer);
        parser.compilationUnit();
        AST ast = parser.getAST();
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
    }

    private static GroovyRecognizer getGroovyParser(String input, SourceBuffer sourceBuffer) {
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader((Reader)new StringReader(input), sourceBuffer);
        GroovyLexer lexer = new GroovyLexer((Reader)unicodeReader);
        unicodeReader.setLexer((CharScanner)lexer);
        GroovyRecognizer parser = GroovyRecognizer.make((GroovyLexer)lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }

    public static class GroovyFileMetadata {
        private boolean isScript = false;
        private final Set<String> classes = new HashSet<String>();
        private final Set<String> staticFields = new HashSet<String>();
        private final Set<String> staticMethods = new HashSet<String>();

        public boolean canImport(String importValue) {
            return this.classes.contains(importValue) || this.staticFields.contains(importValue) || this.staticMethods.contains(importValue);
        }

        public String toString() {
            return "GroovyFileParser.GroovyFileMetadata(isScript=" + this.isScript() + ", classes=" + String.valueOf(this.getClasses()) + ", staticFields=" + String.valueOf(this.getStaticFields()) + ", staticMethods=" + String.valueOf(this.getStaticMethods()) + ")";
        }

        public boolean isScript() {
            return this.isScript;
        }

        public Set<String> getClasses() {
            return this.classes;
        }

        public Set<String> getStaticFields() {
            return this.staticFields;
        }

        public Set<String> getStaticMethods() {
            return this.staticMethods;
        }
    }

    private static class GroovyParseVisitor
    extends VisitorAdapter {
        private final LinkedList<String> classNames;
        private final LinkedList<Integer> levels;
        private final GroovyFileMetadata metadata;
        private int level;
        private boolean isInAnnotation;
        private boolean isInAnnotationArray;

        public GroovyParseVisitor(GroovyFileMetadata metadata) {
            this.metadata = metadata;
            this.classNames = new LinkedList();
            this.levels = new LinkedList();
            this.level = 0;
            this.isInAnnotation = false;
            this.isInAnnotationArray = false;
        }

        public void visitVariableDef(GroovySourceAST t, int visit) {
            if (this.isStatic(t)) {
                this.metadata.staticFields.add(StringUtils.join(this.classNames, (String)"$") + "." + this.getIdent(t));
            }
            super.visitVariableDef(t, visit);
        }

        public void visitMethodDef(GroovySourceAST t, int visit) {
            if (this.isStatic(t)) {
                this.metadata.staticMethods.add(StringUtils.join(this.classNames, (String)"$") + "." + this.getIdent(t));
            }
            super.visitMethodDef(t, visit);
        }

        public void visitEnumConstantDef(GroovySourceAST t, int visit) {
            this.metadata.staticFields.add(StringUtils.join(this.classNames, (String)"$") + "." + this.getIdent(t));
        }

        public void visitClassDef(GroovySourceAST t, int visit) {
            if (visit != 1) {
                return;
            }
            String currentClassName = this.getIdent(t);
            this.classNames.addLast(currentClassName);
            this.levels.addLast(this.level);
            this.level = 0;
            this.metadata.classes.add(StringUtils.join(this.classNames, (String)"$"));
        }

        public void visitObjblock(GroovySourceAST t, int visit) {
            if (visit == 1) {
                ++this.level;
            } else if (visit == 4) {
                --this.level;
                if (this.level == 0) {
                    if (!this.classNames.isEmpty()) {
                        this.classNames.removeLast();
                    }
                    if (!this.levels.isEmpty()) {
                        this.levels.removeLast();
                    }
                    if (!this.levels.isEmpty()) {
                        this.level = this.levels.getLast();
                    }
                }
            }
        }

        public void visitInterfaceDef(GroovySourceAST t, int visit) {
            this.visitClassDef(t, visit);
        }

        public void visitEnumDef(GroovySourceAST t, int visit) {
            this.visitClassDef(t, visit);
        }

        public void visitAnnotationDef(GroovySourceAST t, int visit) {
            this.visitClassDef(t, visit);
        }

        public void visitPackageDef(GroovySourceAST t, int visit) {
        }

        public void visitStaticImport(GroovySourceAST t, int visit) {
        }

        public void visitImport(GroovySourceAST t, int visit) {
        }

        public void visitMlComment(GroovySourceAST t, int visit) {
        }

        public void visitShComment(GroovySourceAST t, int visit) {
        }

        public void visitSlComment(GroovySourceAST t, int visit) {
        }

        public void visitAnnotation(GroovySourceAST t, int visit) {
            if (visit == 1) {
                this.isInAnnotation = true;
            } else if (visit == 4) {
                this.isInAnnotation = false;
            }
        }

        public void visitAnnotations(GroovySourceAST t, int visit) {
            if (visit == 1) {
                this.isInAnnotationArray = true;
            } else if (visit == 4) {
                this.isInAnnotationArray = false;
            }
        }

        public void visitIdent(GroovySourceAST t, int visit) {
        }

        public void visitDot(GroovySourceAST t, int visit) {
        }

        public void visitModifiers(GroovySourceAST t, int visit) {
        }

        public void visitExtendsClause(GroovySourceAST t, int visit) {
        }

        public void visitImplementsClause(GroovySourceAST t, int visit) {
        }

        public void visitAnnotationMemberValuePair(GroovySourceAST t, int visit) {
        }

        public void visitAnnotationArrayInit(GroovySourceAST t, int visit) {
        }

        public void visitDefault(GroovySourceAST t, int visit) {
            if (this.level == 0 && !this.isInAnnotation && !this.isInAnnotationArray) {
                super.visitDefault(t, visit);
                this.metadata.isScript = true;
            }
        }

        private boolean isStatic(GroovySourceAST t) {
            return Optional.ofNullable(t.childOfType(5)).map(it -> it.childOfType(83)).isPresent();
        }

        private String getIdent(GroovySourceAST t) {
            return t.childOfType(87).getText();
        }
    }
}

