/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.ProceedingLep;
import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.groovy.GroovyFileParser;
import com.icthh.xm.commons.lep.groovy.LepResourceConnector;
import com.icthh.xm.commons.lep.groovy.storage.LepStorage;
import com.icthh.xm.commons.lep.impl.LoggingWrapper;
import com.icthh.xm.lep.api.LepMethod;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyLepEngine
extends LepEngine {
    private static final Logger log = LoggerFactory.getLogger(GroovyLepEngine.class);
    public static final String LEP_PREFIX = "lep://";
    public static final String COMMONS_SCRIPT = "/Commons$$";
    private final String tenant;
    private final LepStorage leps;
    private final GroovyScriptEngine gse;
    private final LoggingWrapper loggingWrapper;
    private final LepPathResolver lepPathResolver;
    private final List<String> tenantCommonsFolders;
    private final Map<String, GroovyFileParser.GroovyFileMetadata> lepMetadata = new ConcurrentHashMap<String, GroovyFileParser.GroovyFileMetadata>();

    public GroovyLepEngine(String tenant, LepStorage leps, LoggingWrapper loggingWrapper, ClassLoader classLoader, Map<String, GroovyFileParser.GroovyFileMetadata> lepMetadata, LepResourceConnector lepResourceConnector, LepPathResolver lepPathResolver, boolean isWarmupEnabled) {
        this.tenant = tenant;
        this.leps = leps;
        this.loggingWrapper = loggingWrapper;
        this.gse = this.buildGroovyEngine(classLoader, lepResourceConnector);
        this.lepMetadata.putAll(lepMetadata);
        this.lepPathResolver = lepPathResolver;
        this.tenantCommonsFolders = lepPathResolver.getLepCommonsPaths(tenant);
        if (isWarmupEnabled) {
            this.warmupScripts();
        } else {
            log.warn("Warmup lep script for tenant {} disabled", (Object)tenant);
        }
    }

    protected GroovyScriptEngine buildGroovyEngine(ClassLoader classLoader, LepResourceConnector lepResourceConnector) {
        GroovyScriptEngine gse = new GroovyScriptEngine((ResourceConnector)lepResourceConnector, classLoader);
        CompilerConfiguration config = gse.getConfig();
        config.setRecompileGroovySource(true);
        config.setMinimumRecompilationInterval(50);
        gse.setConfig(config);
        gse.getGroovyClassLoader().setShouldRecompile(Boolean.valueOf(true));
        return gse;
    }

    private void warmupScripts() {
        StopWatch stopWatch = StopWatch.createStarted();
        log.info("Start warmup lep scripts");
        this.leps.forEach(lep -> {
            try {
                if (!this.isCommonsClass(lep.getPath()) && this.lepMetadata.containsKey(lep.metadataKey()) && this.lepMetadata.get(lep.metadataKey()).isScript()) {
                    StopWatch warmUpTime = StopWatch.createStarted();
                    log.info("START | Warmup lep {}", (Object)lep.getPath());
                    Class scriptClass = this.gse.loadScriptByName(LEP_PREFIX + lep.getPath());
                    InvokerHelper.getMetaClass((Class)scriptClass);
                    log.info("STOP | Warmup lep {}, time: {} ms", (Object)lep.getPath(), (Object)warmUpTime.getTime(TimeUnit.MILLISECONDS));
                }
            }
            catch (Throwable e) {
                log.error("Error create script {}", (Object)lep.getPath(), (Object)e);
            }
        });
        log.info("Stop warm-up LEP scripts, time = {} ms, ", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public boolean isExists(LepKey lepKey) {
        List<String> before = this.getBeforeKeys(lepKey);
        List<String> main = this.getMainKeys(lepKey);
        return this.getExistingKey(before).isPresent() || this.getExistingKey(main).isPresent();
    }

    public Object invoke(LepKey lepKey, ProceedingLep lepMethod, BaseLepContext lepContext) {
        List<String> beforeKeys = this.getBeforeKeys(lepKey);
        this.getExistingKey(beforeKeys).ifPresent(key -> this.executeLep((String)key, lepKey, lepMethod, lepContext));
        List<String> mainKeys = this.getMainKeys(lepKey);
        Optional<String> mainKey = this.getExistingKey(mainKeys);
        if (mainKey.isPresent()) {
            return this.executeLep(mainKey.get(), lepKey, lepMethod, lepContext);
        }
        return lepContext.lep.proceed();
    }

    private Object executeLep(String key, LepKey lepKey, ProceedingLep lepMethod, BaseLepContext lepContext) {
        String scriptName = LEP_PREFIX + key + ".groovy";
        return this.loggingWrapper.doWithLogs((LepMethod)lepMethod, scriptName, lepKey, () -> this.gse.run(LEP_PREFIX + key, new Binding(new HashMap<String, BaseLepContext>(Map.of("lepContext", lepContext)))));
    }

    private List<String> getMainKeys(LepKey lepKey) {
        String lepPath = this.lepPathResolver.getLepPath(lepKey, this.tenant);
        String legacyLepPath = this.lepPathResolver.getLegacyLepPath(lepKey, this.tenant);
        return List.of(legacyLepPath + "$$tenant", legacyLepPath + "$$around", lepPath + "$$tenant", lepPath + "$$around", legacyLepPath, lepPath);
    }

    private List<String> getBeforeKeys(LepKey lepKey) {
        String lepPath = this.lepPathResolver.getLepPath(lepKey, this.tenant);
        String legacyLepPath = this.lepPathResolver.getLegacyLepPath(lepKey, this.tenant);
        return List.of(legacyLepPath + "$$before", lepPath + "$$before");
    }

    private Optional<String> getExistingKey(List<String> keys) {
        return keys.stream().filter(this.leps::isExists).findFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCommonsClass(String path) {
        if (path.contains(COMMONS_SCRIPT)) return false;
        if (!this.tenantCommonsFolders.stream().anyMatch(path::startsWith)) return false;
        return true;
    }
}

