/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.GroovyFileParser;
import com.icthh.xm.commons.lep.groovy.storage.LepConnectionCache;
import com.icthh.xm.commons.lep.groovy.storage.LepStorage;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;

public class LepResourceConnector
implements ResourceConnector {
    private static final Logger log = LoggerFactory.getLogger(LepResourceConnector.class);
    private static final String FILE_EXTENSION = ".groovy";
    private static final String LEP_SUFFIX = "$$tenant";
    private static final String LEP_URL_PREFIX = "lep://";
    private final GroovyFileParser groovyFileParser;
    private final LepStorage leps;
    private final Map<String, GroovyFileParser.GroovyFileMetadata> lepMetadata = new ConcurrentHashMap<String, GroovyFileParser.GroovyFileMetadata>();
    private final LepConnectionCache lepConnectionCache;
    private final LepPathResolver lepPathResolver;
    private final String tenantKey;

    public LepResourceConnector(String tenantKey, LepPathResolver lepPathResolver, LepStorage leps, Map<String, GroovyFileParser.GroovyFileMetadata> lepMetadata, GroovyFileParser groovyFileParser) {
        this.tenantKey = tenantKey;
        this.leps = leps;
        this.lepConnectionCache = leps.buildCache();
        this.groovyFileParser = groovyFileParser;
        this.lepMetadata.putAll(lepMetadata);
        this.lepPathResolver = lepPathResolver;
    }

    private GroovyFileParser.GroovyFileMetadata toFileMetaData(XmLepConfigFile lep) {
        return this.groovyFileParser.getFileMetaData(lep.readContent());
    }

    public URLConnection getResourceConnection(String url) {
        Optional<LepPathResolver.LepRootPath> optionalLepBasePath;
        String name = url;
        if (log.isTraceEnabled()) {
            log.trace("Resolve import {}", (Object)name);
        }
        if (this.lepConnectionCache.isConnectionExists(url)) {
            return this.lepConnectionCache.getConnection(url);
        }
        if (name.startsWith(LEP_URL_PREFIX)) {
            name = name.substring(LEP_URL_PREFIX.length());
        }
        if (name.endsWith(FILE_EXTENSION)) {
            name = name.substring(0, name.length() - FILE_EXTENSION.length());
        }
        if ((optionalLepBasePath = this.getLepBasePath(name)).isPresent()) {
            String path;
            LepPathResolver.LepRootPath lepBasePath = optionalLepBasePath.get();
            String currentPath = path = lepBasePath.getPath(name);
            while (true) {
                List<Optional<URLConnection>> connections;
                Optional<URLConnection> connection;
                if ((connection = (connections = List.of(this.toLepConnection(path), this.toLepConnection(currentPath + LEP_SUFFIX, path), this.toLepConnection(currentPath, path))).stream().filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
                    String resolvedFileUrl = connection.get().getURL().toString();
                    if (log.isTraceEnabled()) {
                        log.trace("Resolved {} import at {}", (Object)name, (Object)resolvedFileUrl);
                    }
                    return this.lepConnectionCache.putConnection(url, connection::get);
                }
                if (currentPath.lastIndexOf("$") <= 0) break;
                currentPath = currentPath.substring(0, currentPath.lastIndexOf("$"));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Resource {} not found", (Object)name);
        }
        if (url.startsWith(LEP_URL_PREFIX)) {
            return this.lepConnectionCache.putConnection(url, () -> this.toEmptyLepConnection(url));
        }
        String finalName = name;
        return this.lepConnectionCache.putConnection(url, () -> {
            throw new ResourceException("Resource not found " + finalName);
        });
    }

    private Optional<LepPathResolver.LepRootPath> getLepBasePath(String name) {
        return this.lepPathResolver.getLepPathVariants(this.tenantKey).stream().filter(it -> it.isMatch(name)).findFirst();
    }

    public Optional<URLConnection> toLepConnection(String path) {
        XmLepConfigFile xmLepConfigFile = this.leps.getByPath(path);
        if (xmLepConfigFile != null) {
            URL url = new URL(null, LEP_URL_PREFIX + path, new LepURLStreamHandler(xmLepConfigFile));
            return Optional.of(url.openConnection());
        }
        return Optional.empty();
    }

    public URLConnection toEmptyLepConnection(String path) {
        URL url = new URL(null, LEP_URL_PREFIX + path, new EmptyLepURLStreamHandler(path));
        return url.openConnection();
    }

    public Optional<URLConnection> toLepConnection(String lepUrl, String path) {
        XmLepConfigFile xmLepConfigFile = this.leps.getByPath(lepUrl);
        if (xmLepConfigFile != null && this.containsClassDefinition(lepUrl, path, xmLepConfigFile)) {
            URL url = new URL(null, LEP_URL_PREFIX + lepUrl, new LepURLStreamHandler(xmLepConfigFile));
            return Optional.of(url.openConnection());
        }
        return Optional.empty();
    }

    private boolean containsClassDefinition(String lepUrl, String path, XmLepConfigFile lepFile) {
        String lepPath = lepUrl;
        if (lepPath.endsWith(LEP_SUFFIX)) {
            lepPath = lepPath.substring(0, lepPath.length() - LEP_SUFFIX.length());
        }
        if (!path.startsWith(lepPath)) {
            return false;
        }
        String className = "";
        if (lepPath.lastIndexOf("/") > 0) {
            className = lepPath.substring(lepPath.lastIndexOf("/") + 1);
        }
        Object importValue = path.substring(lepPath.length());
        importValue = className + (String)importValue;
        GroovyFileParser.GroovyFileMetadata metadata = this.lepMetadata.computeIfAbsent(lepFile.metadataKey(), it -> this.toFileMetaData(lepFile));
        return metadata != null && metadata.canImport((String)importValue);
    }

    private static class LepURLStreamHandler
    extends URLStreamHandler {
        private final InputStreamSource content;
        private final long lastModified;

        public LepURLStreamHandler(XmLepConfigFile xmLepConfigFile) {
            this.content = xmLepConfigFile.getContentStream();
            this.lastModified = xmLepConfigFile.getLastModified();
        }

        @Override
        protected URLConnection openConnection(URL u) {
            return new LepURLConnection(u, this.content, this.lastModified);
        }
    }

    private static class EmptyLepURLStreamHandler
    extends URLStreamHandler {
        private final String url;

        @Override
        protected URLConnection openConnection(URL u) {
            return new EmptyLepURLConnection(u);
        }

        public EmptyLepURLStreamHandler(String url) {
            this.url = url;
        }
    }

    private static class EmptyLepURLConnection
    extends URLConnection {
        protected EmptyLepURLConnection(URL url) {
            super(url);
        }

        @Override
        public InputStream getInputStream() {
            throw new ResourceException("Resource not found " + String.valueOf(this.url));
        }

        @Override
        public long getLastModified() {
            return Instant.now().toEpochMilli();
        }

        @Override
        public void connect() {
            throw new ResourceException("Resource not found " + String.valueOf(this.url));
        }
    }

    private static class LepURLConnection
    extends URLConnection {
        private final InputStreamSource inputStream;
        private final long lastModified;

        protected LepURLConnection(URL url, InputStreamSource inputStream, long lastModified) {
            super(url);
            this.inputStream = inputStream;
            this.lastModified = lastModified;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream.getInputStream();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public void connect() {
        }
    }
}

