/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy.storage;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.storage.LepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.XmConfigLepStorage;
import com.icthh.xm.commons.lep.impl.utils.ClassPathLepRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassPathLepStorageFactory
implements LepStorageFactory {
    private final String appName;
    private final Map<String, XmLepConfigFile> defaultLeps;
    private final Map<String, XmLepConfigFile> classPathLeps;
    private final TenantAliasService tenantAliasService;

    public ClassPathLepStorageFactory(String appName, ClassPathLepRepository classPathLepRepository, TenantAliasService tenantAliasService) {
        this.appName = appName;
        this.defaultLeps = classPathLepRepository.getLepFilesFromResources("lep/default");
        this.classPathLeps = classPathLepRepository.getLepFilesFromResources("lep/custom");
        this.tenantAliasService = tenantAliasService;
    }

    @Override
    public XmConfigLepStorage buildXmConfigLepStorage(String tenant, List<XmLepConfigFile> lepFromConfig) {
        HashMap classPathDefaultLeps = new HashMap();
        this.defaultLeps.forEach((key, value) -> {
            String path = tenant + "/" + this.appName + "/lep" + value.getPath();
            classPathDefaultLeps.put(path, new XmLepConfigFile(path, value.getContentStream()));
        });
        List parentTenants = this.tenantAliasService.getTenantAliasTree().getParentKeys(tenant);
        parentTenants.add(0, tenant.toLowerCase());
        Collections.reverse(parentTenants);
        HashMap lepsFromClassPath = new HashMap();
        parentTenants.forEach(tenantKey -> this.classPathLeps.values().forEach(value -> {
            Object path = value.getPath().substring(1);
            String pathTenantKey = ((String)path).substring(0, ((String)path).indexOf("/"));
            if (pathTenantKey.equalsIgnoreCase((String)tenantKey)) {
                path = tenant.toUpperCase() + "/" + this.appName + "/lep" + ((String)path).substring(((String)path).indexOf("/"));
                lepsFromClassPath.put(path, new XmLepConfigFile((String)path, value.getContentStream()));
            }
        }));
        HashMap lepFiles = new HashMap();
        lepFiles.putAll(classPathDefaultLeps);
        lepFiles.putAll(lepsFromClassPath);
        HashMap<String, XmLepConfigFile> leps = new HashMap<String, XmLepConfigFile>();
        lepFiles.forEach((key, lep) -> {
            if (key.endsWith(".groovy")) {
                key = key.substring(0, key.length() - ".groovy".length());
                leps.put((String)key, new XmLepConfigFile(key, lep.getContentStream()));
            }
        });
        return new XmConfigLepStorage(leps);
    }
}

