/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy.storage;

import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.storage.EmptyLepConnectionCache;
import com.icthh.xm.commons.lep.groovy.storage.LepConnectionCache;
import com.icthh.xm.commons.lep.groovy.storage.LepStorage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.InputStreamSource;

public class DirtyClassPathConfigLepStorage
implements LepStorage {
    private final Map<String, XmLepConfigFile> leps = new ConcurrentHashMap<String, XmLepConfigFile>();

    @Override
    public void forEach(Consumer<XmLepConfigFile> action) {
    }

    @Override
    public LepConnectionCache buildCache() {
        return new EmptyLepConnectionCache();
    }

    @Override
    public XmLepConfigFile getByPath(String path) {
        return this.leps.get(path);
    }

    @Override
    public boolean isExists(String path) {
        return this.leps.containsKey(path);
    }

    public void update(Map<String, XmLepConfigFile> leps) {
        HashSet<String> keys = new HashSet<String>(this.leps.keySet());
        keys.removeAll(leps.keySet());
        keys.forEach(this.leps::remove);
        leps.forEach((? super K key, ? super V value) -> {
            if (!this.equalContent(this.leps.get(key), (XmLepConfigFile)value)) {
                this.leps.put((String)key, (XmLepConfigFile)value);
            }
        });
    }

    private boolean equalContent(XmLepConfigFile oldConfig, XmLepConfigFile newConfig) {
        byte[] oldValue = DirtyClassPathConfigLepStorage.getValue(oldConfig);
        byte[] newValue = DirtyClassPathConfigLepStorage.getValue(newConfig);
        return Arrays.equals(oldValue, newValue);
    }

    private static byte[] getValue(XmLepConfigFile firstValue) {
        return Optional.ofNullable(firstValue).map(XmLepConfigFile::getContentStream).map(DirtyClassPathConfigLepStorage.rethrow(InputStreamSource::getInputStream)).map(DirtyClassPathConfigLepStorage.rethrow(IOUtils::toByteArray)).orElse(new byte[0]);
    }

    private static <I, O> Function<I, O> rethrow(FunctionWithException<I, O> value) {
        return i -> DirtyClassPathConfigLepStorage.runFunction(value, i);
    }

    private static <I, O> O runFunction(FunctionWithException<I, O> value, I i) {
        return value.apply(i);
    }

    private static interface FunctionWithException<I, O> {
        public O apply(I var1) throws Exception;
    }
}

