/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.lep.FileSystemUtils;
import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.TenantScriptStorage;
import com.icthh.xm.commons.lep.groovy.CachedGroovyLepEngineCreationStrategy;
import com.icthh.xm.commons.lep.groovy.GroovyEngineCreationStrategy;
import com.icthh.xm.commons.lep.groovy.GroovyFileParser;
import com.icthh.xm.commons.lep.groovy.GroovyLepEngineFactory;
import com.icthh.xm.commons.lep.groovy.GroovyMapLepWrapperFactory;
import com.icthh.xm.commons.lep.groovy.RecreateGroovyLepEngineOnRefresh;
import com.icthh.xm.commons.lep.groovy.annotation.LepServiceTransformation;
import com.icthh.xm.commons.lep.groovy.storage.ClassPathLepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.DirtyClassPathConfigLepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.FileLepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.LepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.XmConfigLepStorageFactory;
import com.icthh.xm.commons.lep.impl.LoggingWrapper;
import com.icthh.xm.commons.lep.impl.utils.ClassPathLepRepository;
import com.icthh.xm.commons.lep.spring.ApplicationNameProvider;
import com.icthh.xm.commons.lep.spring.LepContextActualClassDetector;
import com.icthh.xm.commons.lep.spring.LepSpringConfiguration;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={GroovyLepEngineConfiguration.class})
public class GroovyLepEngineConfiguration
extends LepSpringConfiguration {
    @Value(value="${application.lep.tenant-script-storage:#{null}}")
    private TenantScriptStorage tenantScriptStorageType;
    @Value(value="${application.lep.warmup-scripts:true}")
    private boolean warmupScripts;
    @Value(value="${application.lep.warmup-scripts-for-all-tenant:false}")
    private boolean warmupScriptsForAllTenant;
    @Value(value="${application.lep.recreate-groovy-engine-on-refresh:true}")
    private boolean recreateGroovyEngineOnRefresh;
    @Value(value="${application.lep.tenants-with-lep-warmup:#{T(java.util.Set).of('XM')}}")
    private Set<String> tenantsWithLepWarmup;

    public GroovyLepEngineConfiguration(@Value(value="${spring.application.name}") String appName) {
        super(appName);
    }

    @Bean
    public GroovyLepEngineFactory groovyLepEngineFactory(ApplicationNameProvider applicationNameProvider, LepStorageFactory lepStorageFactory, GroovyEngineCreationStrategy groovyEngineCreationStrategy, LoggingWrapper loggingWrapper, LepPathResolver lepPathResolver, GroovyFileParser groovyFileParser) {
        String appName = applicationNameProvider.getAppName();
        return new GroovyLepEngineFactory(appName, lepStorageFactory, groovyEngineCreationStrategy, loggingWrapper, lepPathResolver, groovyFileParser, this.warmupScripts ? this.tenantsWithLepWarmup : Collections.emptySet(), this.warmupScriptsForAllTenant);
    }

    @Bean
    public GroovyMapLepWrapperFactory groovyMapLepWrapperFactory() {
        return new GroovyMapLepWrapperFactory();
    }

    @Bean
    public LepServiceTransformation lepServiceTransformation(LepContextActualClassDetector lepContextActualClassDetector) {
        LepServiceTransformation lepServiceTransformation = new LepServiceTransformation();
        LepServiceTransformation.init(lepContextActualClassDetector.detectActualClass());
        return lepServiceTransformation;
    }

    @Bean
    @ConditionalOnMissingBean(value={GroovyFileParser.class})
    public GroovyFileParser groovyFileParser() {
        return new GroovyFileParser();
    }

    @Bean
    public LepStorageFactory lepStorageFactory(ApplicationNameProvider applicationNameProvider, ClassPathLepRepository classPathLepRepository, LepPathResolver lepPathResolver, TenantAliasService tenantAliasService) {
        String appName = applicationNameProvider.getAppName();
        TenantScriptStorage storageType = this.getTenantScriptStorageType();
        if (storageType.equals((Object)TenantScriptStorage.XM_MS_CONFIG)) {
            return new XmConfigLepStorageFactory(appName, classPathLepRepository);
        }
        if (storageType.equals((Object)TenantScriptStorage.CLASSPATH)) {
            return new ClassPathLepStorageFactory(appName, classPathLepRepository, tenantAliasService);
        }
        if (storageType.equals((Object)TenantScriptStorage.FILE)) {
            return new FileLepStorageFactory(appName, classPathLepRepository, tenantAliasService, lepPathResolver, this.getFileTenantScriptPathResolverBaseDir());
        }
        if (storageType.equals((Object)TenantScriptStorage.XM_MS_CONFIG_DIRTY_CLASSPATH)) {
            return new DirtyClassPathConfigLepStorageFactory(new XmConfigLepStorageFactory(appName, classPathLepRepository));
        }
        throw new RuntimeException("Unsupported storage type");
    }

    @Bean
    protected GroovyEngineCreationStrategy groovyEngineCreationStrategy() {
        if (this.recreateGroovyEngineOnRefresh) {
            return new RecreateGroovyLepEngineOnRefresh();
        }
        return new CachedGroovyLepEngineCreationStrategy();
    }

    protected String getFileTenantScriptPathResolverBaseDir() {
        return FileSystemUtils.getAppHomeDir();
    }

    protected TenantScriptStorage getTenantScriptStorageType() {
        if (this.tenantScriptStorageType == null) {
            this.tenantScriptStorageType = this.recreateGroovyEngineOnRefresh ? TenantScriptStorage.XM_MS_CONFIG : TenantScriptStorage.XM_MS_CONFIG_DIRTY_CLASSPATH;
        }
        if (this.tenantScriptStorageType == TenantScriptStorage.XM_MS_CONFIG && !this.recreateGroovyEngineOnRefresh) {
            throw new IllegalArgumentException("XM_MS_CONFIG storage type is not supported with recreateGroovyEngineOnRefresh=false");
        }
        return this.tenantScriptStorageType;
    }
}

