/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepEngineFactory;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.GroovyEngineCreationStrategy;
import com.icthh.xm.commons.lep.groovy.GroovyFileParser;
import com.icthh.xm.commons.lep.groovy.LepResourceConnector;
import com.icthh.xm.commons.lep.groovy.storage.LepStorage;
import com.icthh.xm.commons.lep.groovy.storage.LepStorageFactory;
import com.icthh.xm.commons.lep.impl.LoggingWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;

public class GroovyLepEngineFactory
extends LepEngineFactory
implements BeanClassLoaderAware {
    private final LepStorageFactory lepStorageFactory;
    private final LoggingWrapper loggingWrapper;
    private final GroovyFileParser groovyFileParser;
    private final LepPathResolver lepPathResolver;
    private final Set<String> tenantWithWarmup;
    private final Boolean warmupScriptsForAllTenants;
    private final GroovyEngineCreationStrategy groovyEngineCreationStrategy;
    private volatile ClassLoader classLoader;

    public GroovyLepEngineFactory(String appName, LepStorageFactory lepStorageFactory, GroovyEngineCreationStrategy groovyEngineCreationStrategy, LoggingWrapper loggingWrapper, LepPathResolver lepPathResolver, GroovyFileParser groovyFileParser, Set<String> tenantWithWarmup, Boolean warmupScriptsForAllTenants) {
        super(appName);
        this.lepPathResolver = lepPathResolver;
        this.lepStorageFactory = lepStorageFactory;
        this.groovyEngineCreationStrategy = groovyEngineCreationStrategy;
        this.loggingWrapper = loggingWrapper;
        this.groovyFileParser = groovyFileParser;
        this.tenantWithWarmup = tenantWithWarmup;
        this.warmupScriptsForAllTenants = warmupScriptsForAllTenants;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public LepEngine createLepEngine(String tenant, List<XmLepConfigFile> lepFromConfig) {
        LepStorage lepConfigStorage = this.lepStorageFactory.buildXmConfigLepStorage(tenant, lepFromConfig);
        HashMap<String, GroovyFileParser.GroovyFileMetadata> lepMetadata = new HashMap<String, GroovyFileParser.GroovyFileMetadata>();
        lepConfigStorage.forEach(lep -> lepMetadata.put(lep.metadataKey(), this.groovyFileParser.getFileMetaData(lep.readContent())));
        LepResourceConnector lepResourceConnector = new LepResourceConnector(tenant, this.lepPathResolver, lepConfigStorage, lepMetadata, this.groovyFileParser);
        boolean isWarmupEnabled = Boolean.TRUE.equals(this.warmupScriptsForAllTenants) || this.tenantWithWarmup.contains(tenant);
        return this.groovyEngineCreationStrategy.createEngine(tenant, lepConfigStorage, this.loggingWrapper, this.classLoader, lepMetadata, lepResourceConnector, this.lepPathResolver, isWarmupEnabled);
    }
}

