/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy;

import com.icthh.xm.commons.lep.TargetProceedingLep;
import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.groovy.GroovyLepEngine;
import com.icthh.xm.commons.lep.spring.LepContextCustomizer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyMapLepWrapperFactory
implements LepContextCustomizer {
    private static final Logger log = LoggerFactory.getLogger(GroovyMapLepWrapperFactory.class);
    private static final MethodHandle constructorHandle = GroovyMapLepWrapperFactory.buildConstructorHandle();

    private static MethodHandle buildConstructorHandle() {
        try {
            Class<?> mapWrapperClass = Class.forName("com.icthh.xm.commons.GroovyMapLepContextWrapper");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(Void.TYPE, BaseLepContext.class);
            return lookup.findConstructor(mapWrapperClass, methodType);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            log.error("Groovy lepContext Map wrapper is not available. Add to gradle \"annotationProcessor 'com.icthh.xm.commons:xm-commons-lep-annotation-processor:${xm_commons_version}'\"");
            return null;
        }
    }

    public BaseLepContext customize(BaseLepContext lepContext, LepEngine lepEngine, TargetProceedingLep lepMethod) {
        if (constructorHandle != null && lepEngine instanceof GroovyLepEngine) {
            return constructorHandle.invoke(lepContext);
        }
        return lepContext;
    }
}

