/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy.annotation;

import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.groovy.annotation.LepConstructor;
import com.icthh.xm.commons.lep.groovy.annotation.LepIgnoreInject;
import com.icthh.xm.commons.lep.groovy.annotation.LepInject;
import com.icthh.xm.commons.lep.groovy.annotation.LepInjectableService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LepServiceTransformation
extends AbstractASTTransformation {
    private static final Logger log = LoggerFactory.getLogger(LepServiceTransformation.class);
    private static volatile Map<String, List<String>> LEP_CONTEXT_FIELDS;
    private static volatile Set<String> LEP_CONTEXT_TYPE_HIERARCHY;
    private static volatile Set<String> LEP_CONTEXT_CLASS_HIERARCHY;
    public static final String LEP_CONTEXT_NAME = "lepContext";

    public static void init(Class<? extends BaseLepContext> lepContextClass) {
        Set<Class<?>> typeHierarchy = LepServiceTransformation.buildTypeHierarchy(lepContextClass);
        Set<Class<?>> classHierarchy = typeHierarchy.stream().filter(BaseLepContext.class::isAssignableFrom).collect(Collectors.toSet());
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        classHierarchy.forEach(type -> LepServiceTransformation.getFields(fields, "", type));
        String canonicalName = lepContextClass.getCanonicalName();
        if (canonicalName != null) {
            fields.put(canonicalName, List.of("with{it}"));
        }
        typeHierarchy.forEach(it -> fields.putIfAbsent(it.getCanonicalName(), List.of("with{it}")));
        LEP_CONTEXT_CLASS_HIERARCHY = Set.copyOf(LepServiceTransformation.toCanonicalNames(classHierarchy));
        LEP_CONTEXT_TYPE_HIERARCHY = Set.copyOf(LepServiceTransformation.toCanonicalNames(typeHierarchy));
        LEP_CONTEXT_FIELDS = Map.copyOf(fields);
    }

    private static Set<String> toCanonicalNames(Set<Class<?>> typeHierarchy) {
        return typeHierarchy.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    private static Set<Class<?>> buildTypeHierarchy(Class<? extends BaseLepContext> lepContextClass) {
        HashSet typeHierarchy = new HashSet();
        for (Class<? extends BaseLepContext> currentClass = lepContextClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            typeHierarchy.add(currentClass);
            typeHierarchy.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        return typeHierarchy;
    }

    private static void getFields(Map<String, List<String>> fields, String basePath, Class<?> type) {
        HashSet memberClasses = new HashSet(List.of(type.getNestMembers()));
        Arrays.stream(type.getFields()).filter(field -> !field.getType().isAssignableFrom(Object.class)).filter(field -> !memberClasses.contains(field.getType())).forEach(field -> {
            fields.putIfAbsent(field.getType().getCanonicalName(), new ArrayList());
            ((List)fields.get(field.getType().getCanonicalName())).add(basePath + field.getName());
        });
        Arrays.stream(type.getFields()).filter(field -> memberClasses.contains(field.getType())).forEach(field -> LepServiceTransformation.getFields(fields, field.getName() + ".", field.getType()));
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        try {
            this.internalVisit(nodes, source);
        }
        catch (Throwable e) {
            log.error("Error during LepServiceTransformation", e);
            throw e;
        }
    }

    private void internalVisit(ASTNode[] nodes, SourceUnit source) {
        ClassNode classNode = (ClassNode)nodes[1];
        boolean isLepServiceFactoryEnabled = this.isLepServiceFactoryEnabled(nodes);
        List<Statement> statements = this.generateFieldAssignment(classNode, isLepServiceFactoryEnabled);
        Optional<ConstructorNode> constructor = this.findExistingLepConstructor(classNode);
        String mockClass = "\n class A { public A(def lepContext) {  } }";
        List ast = new AstBuilder().buildFromString(CompilePhase.CANONICALIZATION, true, mockClass);
        ConstructorNode generatedConstructor = (ConstructorNode)((ClassNode)ast.get(1)).getDeclaredConstructors().get(0);
        generatedConstructor.setCode((Statement)new BlockStatement(statements, new VariableScope()));
        if (constructor.isPresent() && constructor.get().getParameters().length > 0) {
            ConstructorNode original = constructor.get();
            ArrayList<Statement> constructorStatements = new ArrayList<Statement>(statements);
            constructorStatements.add(original.getCode());
            original.setCode((Statement)new BlockStatement(constructorStatements, new VariableScope()));
        } else if (constructor.isPresent() && constructor.get().getParameters().length == 0) {
            ConstructorNode original = constructor.get();
            ArrayList<Statement> constructorStatements = new ArrayList<Statement>(statements);
            constructorStatements.add(original.getCode());
            generatedConstructor.setCode((Statement)new BlockStatement(constructorStatements, new VariableScope()));
            classNode.removeConstructor(constructor.get());
            classNode.addConstructor(generatedConstructor);
        } else {
            classNode.addConstructor(generatedConstructor);
        }
    }

    private Statement createAssignment(String fieldName, String rhsExpression) {
        VariableExpression thisExpression = new VariableExpression("this");
        PropertyExpression fieldExpression = new PropertyExpression((Expression)thisExpression, fieldName);
        Expression rhsExpr = this.createExpression(rhsExpression);
        return new ExpressionStatement((Expression)new BinaryExpression((Expression)fieldExpression, Token.newSymbol((String)"=", (int)-1, (int)-1), rhsExpr));
    }

    private Statement createServiceInstance(FieldNode field) {
        VariableExpression thisExpression = new VariableExpression("this");
        PropertyExpression fieldExpression = new PropertyExpression((Expression)thisExpression, field.getName());
        List constructors = field.getType().getDeclaredConstructors();
        if (constructors.stream().anyMatch(this::isLepContextConstructor) || LepServiceTransformation.isAnnotated((AnnotatedNode)field.getType(), LepConstructor.class)) {
            return LepServiceTransformation.callLepConstructor(field, (Expression)fieldExpression);
        }
        if (constructors.isEmpty() || LepServiceTransformation.hasEmptyArgumentConstructor(field.getType())) {
            return new ExpressionStatement((Expression)new BinaryExpression((Expression)fieldExpression, Token.newSymbol((String)"=", (int)-1, (int)-1), (Expression)new ConstructorCallExpression(field.getType(), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        }
        log.error("No suitable class constructor found for field {}", (Object)field.getName());
        return LepServiceTransformation.callLepConstructor(field, (Expression)fieldExpression);
    }

    private static ExpressionStatement callLepConstructor(FieldNode field, Expression fieldExpression) {
        ConstructorCallExpression classConstructorCall = new ConstructorCallExpression(field.getType(), (Expression)new ArgumentListExpression((Expression)new VariableExpression(LEP_CONTEXT_NAME)));
        return new ExpressionStatement((Expression)new BinaryExpression(fieldExpression, Token.newSymbol((String)"=", (int)-1, (int)-1), (Expression)classConstructorCall));
    }

    private static boolean hasEmptyArgumentConstructor(ClassNode type) {
        return type.getDeclaredConstructors().stream().anyMatch(it -> it.getParameters().length == 0);
    }

    private Expression createExpression(String expression) {
        String[] parts = expression.split("\\.");
        VariableExpression result = new VariableExpression(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            result = new PropertyExpression((Expression)result, parts[i]);
        }
        return result;
    }

    private boolean isLepServiceFactoryEnabled(ASTNode[] nodes) {
        Expression expression;
        AnnotationNode annotationNode = null;
        for (ASTNode node : nodes) {
            if (!(node instanceof AnnotationNode) || !((AnnotationNode)node).getClassNode().getName().equals(LepConstructor.class.getCanonicalName())) continue;
            annotationNode = (AnnotationNode)node;
            break;
        }
        if (annotationNode != null && (expression = annotationNode.getMember("useLepFactory")) instanceof ConstantExpression) {
            return Boolean.parseBoolean(((ConstantExpression)expression).getValue().toString());
        }
        return true;
    }

    private List<Statement> generateFieldAssignment(ClassNode classNode, boolean isLepServiceFactoryEnabled) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        classNode.getFields().forEach(field -> {
            if (LEP_CONTEXT_CLASS_HIERARCHY.contains(field.getType().getName()) || LepServiceTransformation.lepContextConventionField(field)) {
                statements.add(this.createAssignment(field.getName(), LEP_CONTEXT_NAME));
            } else if (LepServiceTransformation.canBeInjected(field) && this.isInLepContext((FieldNode)field)) {
                this.generateFieldFromLepContextAssigment((List<Statement>)statements, (FieldNode)field);
            } else if (LepServiceTransformation.canBeInjected(field) && this.isLepService((FieldNode)field)) {
                this.generateLepServiceCreations((List<Statement>)statements, classNode, (FieldNode)field, isLepServiceFactoryEnabled);
            }
        });
        return statements;
    }

    private static boolean lepContextConventionField(FieldNode field) {
        return field.getName().equals(LEP_CONTEXT_NAME) && (field.isDynamicTyped() || LEP_CONTEXT_TYPE_HIERARCHY.contains(field.getType().getName()));
    }

    private static boolean canBeInjected(FieldNode field) {
        return !field.isStatic() && (field.isFinal() || LepServiceTransformation.isAnnotated((AnnotatedNode)field, LepInject.class)) && !LepServiceTransformation.isAnnotated((AnnotatedNode)field, LepIgnoreInject.class);
    }

    private static boolean isAnnotated(AnnotatedNode node, Class<? extends Annotation> annotationClass) {
        return node.getAnnotations().stream().anyMatch(it -> it.getClassNode().getName().equals(annotationClass.getCanonicalName()));
    }

    private void generateLepServiceCreations(List<Statement> statements, ClassNode classNode, FieldNode field, boolean isLepServiceFactoryEnabled) {
        this.addImportToClass(classNode, field);
        if (isLepServiceFactoryEnabled) {
            statements.add(this.createServiceInstanceUsingGetInstance(field));
        } else {
            statements.add(this.createServiceInstance(field));
        }
    }

    private Statement createServiceInstanceUsingGetInstance(FieldNode field) {
        VariableExpression thisExpression = new VariableExpression("this");
        PropertyExpression fieldExpression = new PropertyExpression((Expression)thisExpression, field.getName());
        VariableExpression lepContextExpression = new VariableExpression(LEP_CONTEXT_NAME);
        PropertyExpression lepServicesExpression = new PropertyExpression((Expression)lepContextExpression, "lepServices");
        MethodCallExpression getInstanceMethodCall = new MethodCallExpression((Expression)lepServicesExpression, "getInstance", (Expression)new ArgumentListExpression((Expression)new ClassExpression(field.getType())));
        return new ExpressionStatement((Expression)new BinaryExpression((Expression)fieldExpression, Token.newSymbol((String)"=", (int)-1, (int)-1), (Expression)getInstanceMethodCall));
    }

    private void addImportToClass(ClassNode classNode, FieldNode field) {
        ModuleNode moduleNode = classNode.getModule();
        if (moduleNode == null) {
            return;
        }
        String typeName = field.getType().getName();
        boolean importExists = moduleNode.getImports().stream().anyMatch(importNode -> typeName.equals(importNode.getClassName()));
        if (importExists) {
            return;
        }
        moduleNode.addImport(typeName, field.getType());
    }

    private void generateFieldFromLepContextAssigment(List<Statement> statements, FieldNode field) {
        String lepContextFieldName = "lepContext." + this.getFieldName(field);
        statements.add(this.createAssignment(field.getName(), lepContextFieldName));
    }

    private Optional<ConstructorNode> findExistingLepConstructor(ClassNode classNode) {
        return classNode.getDeclaredConstructors().stream().filter(it -> {
            boolean isNeededConstructor = false;
            if (it.getParameters().length == 0) {
                isNeededConstructor = true;
            } else if (it.getParameters().length == 1) {
                Parameter parameter = it.getParameters()[0];
                boolean bl = isNeededConstructor = parameter.getName().equals(LEP_CONTEXT_NAME) && this.isLepContextConstructor((ConstructorNode)it);
            }
            if (!isNeededConstructor) {
                log.warn("Constructor {} is not suitable for LepConstructor annotation. This must be constructor with exactly one argument with name \"lepContext\"", it);
            }
            return isNeededConstructor;
        }).findFirst();
    }

    private boolean isLepContextConstructor(ConstructorNode constructorNode) {
        if (constructorNode.getParameters().length == 1) {
            Parameter parameter = constructorNode.getParameters()[0];
            ClassNode parameterType = parameter.getType();
            return LEP_CONTEXT_TYPE_HIERARCHY.contains(parameterType.getName());
        }
        return false;
    }

    private boolean isLepService(FieldNode field) {
        return LepServiceTransformation.isAnnotated((AnnotatedNode)field.getType(), LepConstructor.class) || LepServiceTransformation.isAnnotated((AnnotatedNode)field.getType(), LepInjectableService.class);
    }

    private boolean isInLepContext(FieldNode field) {
        return LEP_CONTEXT_FIELDS.containsKey(field.getType().getName());
    }

    private String getFieldName(FieldNode field) {
        List<String> candidates = LEP_CONTEXT_FIELDS.get(field.getType().getName());
        String lepContextFieldName = candidates.get(0);
        if (candidates.size() > 1) {
            LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
            lepContextFieldName = candidates.stream().min(Comparator.comparing(name -> levenshteinDistance.apply((CharSequence)name.toLowerCase(), (CharSequence)field.getName().toLowerCase()))).get();
        }
        return lepContextFieldName;
    }
}

