/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy.storage;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.lep.LepPathResolver;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.storage.EmptyLepConnectionCache;
import com.icthh.xm.commons.lep.groovy.storage.LepConnectionCache;
import com.icthh.xm.commons.lep.groovy.storage.LepStorage;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class FileLepStorage
implements LepStorage {
    private static final String TENANT_PREFIX = "/config/tenants/";
    private final String tenant;
    private final String appName;
    private final Map<String, XmLepConfigFile> defaultLeps;
    private final TenantAliasService tenantAliasService;
    private final List<String> baseDirs;
    private final String baseDir;

    public FileLepStorage(String tenant, String appName, Map<String, XmLepConfigFile> defaultLeps, TenantAliasService tenantAliasService, LepPathResolver lepPathResolver, String baseDir) {
        this.tenant = tenant;
        this.appName = appName;
        this.tenantAliasService = tenantAliasService;
        this.baseDir = baseDir;
        HashMap<String, XmLepConfigFile> classPathDefaultLeps = new HashMap<String, XmLepConfigFile>();
        defaultLeps.forEach((? super K key, ? super V value) -> {
            String path = tenant + "/" + appName + "/lep" + value.getPath();
            classPathDefaultLeps.put(path, new XmLepConfigFile(path, value.getContentStream()));
        });
        this.defaultLeps = classPathDefaultLeps;
        this.baseDirs = lepPathResolver.getLepBasePaths(tenant).stream().map(path -> baseDir + TENANT_PREFIX + path).collect(Collectors.toList());
        Collections.reverse(this.baseDirs);
    }

    @Override
    public void forEach(Consumer<XmLepConfigFile> action) {
        HashMap<String, XmLepConfigFile> leps = new HashMap<String, XmLepConfigFile>(this.defaultLeps);
        this.baseDirs.stream().map(File::new).filter(File::exists).forEach((? super T rootDir) -> {
            Collection files = FileUtils.listFiles((File)rootDir, (String[])new String[]{"groovy"}, (boolean)true);
            files.forEach((? super T file) -> FileLepStorage.toXmLepConfigFile(rootDir, file, leps));
        });
        leps.values().forEach(action);
    }

    private static void toXmLepConfigFile(File rootDir, File file, Map<String, XmLepConfigFile> leps) {
        String path = file.getAbsolutePath().substring(rootDir.getAbsolutePath().length());
        leps.put(path, FileLepStorage.toXmLepConfigFile(path, file));
    }

    private static XmLepConfigFile toXmLepConfigFile(String path, final File value) {
        return new XmLepConfigFile(path, () -> new FileInputStream(value)){

            public long getLastModified() {
                return value.lastModified();
            }
        };
    }

    @Override
    public XmLepConfigFile getByPath(String path) {
        if (this.defaultLeps.containsKey(path + ".groovy")) {
            return this.defaultLeps.get(path + ".groovy");
        }
        Optional<File> file = this.findFile(path + ".groovy").filter(File::exists);
        return file.map(value -> FileLepStorage.toXmLepConfigFile(path, value)).orElse(null);
    }

    @Override
    public boolean isExists(String path) {
        return this.defaultLeps.containsKey(path + ".groovy") || this.findFile(path + ".groovy").isPresent();
    }

    private Optional<File> findFile(String path) {
        List parentKeys = this.tenantAliasService.getTenantAliasTree().getParentKeys(this.tenant);
        parentKeys.add(0, this.tenant);
        return parentKeys.stream().map(tenantKey -> this.replaceTenantName(TENANT_PREFIX + path, (String)tenantKey)).map(it -> this.baseDir + it).map(File::new).filter(File::exists).findFirst();
    }

    private String replaceTenantName(String path, String targetTenant) {
        path = path.replace(this.getLepPath(this.tenant, this.appName), this.getLepPath(targetTenant, this.appName));
        path = path.replace(this.getLepPath(this.tenant, "commons"), this.getLepPath(targetTenant, "commons"));
        return path;
    }

    private String getLepPath(String tenant, String subfolder) {
        return TENANT_PREFIX + tenant + "/" + subfolder + "/lep/";
    }

    @Override
    public LepConnectionCache buildCache() {
        return new EmptyLepConnectionCache();
    }
}

