/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.groovy.storage;

import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.groovy.storage.LepStorageFactory;
import com.icthh.xm.commons.lep.groovy.storage.XmConfigLepStorage;
import com.icthh.xm.commons.lep.impl.utils.ClassPathLepRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmConfigLepStorageFactory
implements LepStorageFactory {
    private final String appName;
    private final Map<String, XmLepConfigFile> defaultLeps;

    public XmConfigLepStorageFactory(String appName, ClassPathLepRepository classPathLepRepository) {
        this.appName = appName;
        this.defaultLeps = classPathLepRepository.getLepFilesFromResources("lep/default");
    }

    @Override
    public XmConfigLepStorage buildXmConfigLepStorage(String tenant, List<XmLepConfigFile> lepFromConfig) {
        HashMap classPathDefaultLeps = new HashMap();
        this.defaultLeps.forEach((key, value) -> {
            String path = tenant + "/" + this.appName + "/lep" + value.getPath();
            classPathDefaultLeps.put(path, new XmLepConfigFile(path, value.getContentStream()));
        });
        String configPrefix = "/config/tenants/";
        HashMap lepsFromConfig = new HashMap();
        lepFromConfig.forEach(value -> {
            String path = value.getPath().substring(configPrefix.length());
            lepsFromConfig.put(path, new XmLepConfigFile(path, value.getContentStream()));
        });
        HashMap lepFiles = new HashMap();
        lepFiles.putAll(classPathDefaultLeps);
        lepFiles.putAll(lepsFromConfig);
        HashMap<String, XmLepConfigFile> leps = new HashMap<String, XmLepConfigFile>();
        lepFiles.forEach((key, lep) -> {
            if (key.endsWith(".groovy")) {
                key = key.substring(0, key.length() - ".groovy".length());
                leps.put((String)key, new XmLepConfigFile(key, lep.getContentStream()));
            }
        });
        return new XmConfigLepStorage(leps);
    }
}

