/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.js;

import com.icthh.xm.commons.lep.ProceedingLep;
import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.impl.LoggingWrapper;
import com.icthh.xm.lep.api.LepMethod;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsLepEngine
extends LepEngine {
    private static final Logger log = LoggerFactory.getLogger(JsLepEngine.class);
    private final String tenant;
    private final String appName;
    private final Map<String, XmLepConfigFile> leps;
    private final LoggingWrapper loggingWrapper;

    public boolean isExists(LepKey lepKey) {
        String lepPath = this.toLepPath(lepKey);
        boolean exists = this.leps.containsKey(lepPath);
        if (!exists) {
            log.debug("Lep in js engine by path {} not found.", (Object)lepPath);
        }
        return exists;
    }

    public int order() {
        return 1;
    }

    public Object invoke(LepKey lepKey, ProceedingLep lepMethod, BaseLepContext lepContext) {
        String lepPath = this.toLepPath(lepKey);
        if (this.leps.containsKey(lepPath)) {
            String lepName = this.toLepName(lepKey);
            return this.loggingWrapper.doWithLogs((LepMethod)lepMethod, lepName, lepKey, () -> this.runJsCode(this.leps.get(lepPath), lepContext, lepName));
        }
        return lepContext.lep.proceed();
    }

    private Object runJsCode(XmLepConfigFile xmLepConfigFile, BaseLepContext lepContext, String lepName) {
        Object object;
        block8: {
            Context context = Context.enter();
            try {
                ScriptableObject scope = context.initStandardObjects();
                Object wrappedLepContext = Context.javaToJS((Object)lepContext, (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)scope, (String)"lepContext", (Object)wrappedLepContext);
                String jsCode = IOUtils.toString((InputStream)xmLepConfigFile.getContentStream().getInputStream(), (Charset)StandardCharsets.UTF_8);
                object = context.evaluateString((Scriptable)scope, jsCode, lepName, 1, null);
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            context.close();
        }
        return object;
    }

    private String toLepName(LepKey lepKey) {
        Object lepName = lepKey.getBaseKey();
        List segments = lepKey.getSegments();
        if (CollectionUtils.isNotEmpty((Collection)segments)) {
            lepName = (String)lepName + "__" + StringUtils.join((Iterable)segments, (String)"__");
        }
        return lepName;
    }

    private String toLepPath(LepKey lepKey) {
        Object lepPath = lepKey.getBaseKey();
        List segments = lepKey.getSegments();
        if (StringUtils.isNotBlank((CharSequence)lepKey.getGroup())) {
            lepPath = lepKey.getGroup().replace(".", "/") + "/" + lepKey.getBaseKey();
        }
        if (CollectionUtils.isNotEmpty((Collection)segments)) {
            lepPath = (String)lepPath + "__" + StringUtils.join((Iterable)segments, (String)"__");
        }
        lepPath = "/config/tenants/" + this.tenant + "/" + this.appName + "/lep/" + (String)lepPath + ".js";
        return lepPath;
    }

    public JsLepEngine(String tenant, String appName, Map<String, XmLepConfigFile> leps, LoggingWrapper loggingWrapper) {
        this.tenant = tenant;
        this.appName = appName;
        this.leps = leps;
        this.loggingWrapper = loggingWrapper;
    }
}

