/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.js;

import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepEngineFactory;
import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import com.icthh.xm.commons.lep.impl.LoggingWrapper;
import com.icthh.xm.commons.lep.js.JsLepEngine;
import com.icthh.xm.commons.lep.spring.ApplicationNameProvider;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsLepEngineFactory
extends LepEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(JsLepEngineFactory.class);
    private final LoggingWrapper loggingWrapper;

    public JsLepEngineFactory(ApplicationNameProvider applicationNameProvider, LoggingWrapper loggingWrapper) {
        super(applicationNameProvider.getAppName());
        this.loggingWrapper = loggingWrapper;
    }

    public LepEngine createLepEngine(String tenant, List<XmLepConfigFile> lepFromConfig) {
        HashMap<String, XmLepConfigFile> leps = new HashMap<String, XmLepConfigFile>();
        lepFromConfig.stream().filter(it -> it.getPath().endsWith(".js")).forEach(it -> leps.put(it.getPath(), (XmLepConfigFile)it));
        return new JsLepEngine(tenant, this.getAppName(), leps, this.loggingWrapper);
    }
}

