/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.FileSystemUtils;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;

public enum TenantScriptStorage {
    CLASSPATH(TenantScriptStorage::getScriptPathClasspath, TenantScriptStorage::getDetailsClasspath),
    XM_MS_CONFIG(TenantScriptStorage::getScriptPathMsConfig, TenantScriptStorage::getDetails),
    FILE(TenantScriptStorage::getScriptPathFile, TenantScriptStorage::getDetails);

    private final Function<Details, String> getScriptPath;
    private final DetailsExtractor getDetails;
    private static final String URL_PREFIX_COMMONS_ENVIRONMENT = "/commons/environment";
    private static final String URL_PREFIX_COMMONS_TENANT = "/commons/tenant";

    private TenantScriptStorage(Function<Details, String> getScriptPath, DetailsExtractor getDetails) {
        this.getDetails = getDetails;
        this.getScriptPath = getScriptPath;
    }

    private static String getScriptPathClasspath(Details details) {
        List<String> paths = PathBuilder.builder().path((String)"classpath:").path((String)"lep").path((String)"custom").paths(details.basePath).path((String)details.path).build().paths;
        return String.join((CharSequence)"/", paths);
    }

    private static String getScriptPathMsConfig(Details details) {
        List<String> paths = PathBuilder.builder().path((String)"xm-ms-config:").path((String)"config").path((String)"tenants").paths(details.basePath).path((String)details.path).build().paths;
        return String.join((CharSequence)"/", paths);
    }

    private static String getScriptPathFile(Details details) {
        String[] paths = PathBuilder.builder().path("config").path("tenants").paths(details.basePath).build().asArray();
        String lepDir = Paths.get(FileSystemUtils.APP_HOME_DIR, paths).toString();
        String path = "/" + details.path;
        if (SystemUtils.IS_OS_WINDOWS) {
            return "file:///" + lepDir + FilenameUtils.separatorsToSystem((String)path);
        }
        return "file://" + lepDir + FilenameUtils.separatorsToSystem((String)path);
    }

    private static Details getDetails(String tenantKey, String appName, String path) {
        if (path.startsWith(URL_PREFIX_COMMONS_ENVIRONMENT)) {
            return new Details(Arrays.asList("commons", "lep"), path.substring(URL_PREFIX_COMMONS_ENVIRONMENT.length()));
        }
        if (path.startsWith(URL_PREFIX_COMMONS_TENANT)) {
            return new Details(Arrays.asList(tenantKey.toUpperCase(), "commons", "lep"), path.substring(URL_PREFIX_COMMONS_TENANT.length()));
        }
        return new Details(Arrays.asList(tenantKey.toUpperCase(), appName, "lep"), path);
    }

    private static Details getDetailsClasspath(String tenantKey, String appName, String path) {
        if (path.startsWith(URL_PREFIX_COMMONS_ENVIRONMENT)) {
            return new Details(Collections.emptyList(), path.substring(URL_PREFIX_COMMONS_ENVIRONMENT.length()));
        }
        if (path.startsWith(URL_PREFIX_COMMONS_TENANT)) {
            return new Details(Collections.singletonList(tenantKey.toLowerCase()), path.substring(URL_PREFIX_COMMONS_TENANT.length()));
        }
        return new Details(Collections.singletonList(tenantKey.toLowerCase()), path);
    }

    public String resolvePath(String tenantKey, String appName, String path) {
        Details details = this.getDetails.extract(tenantKey, appName, path);
        return this.getScriptPath.apply(details);
    }

    private static class PathBuilder {
        private final List<String> paths;

        public String[] asArray() {
            return this.paths.toArray(new String[0]);
        }

        PathBuilder(List<String> paths) {
            this.paths = paths;
        }

        public static PathBuilderBuilder builder() {
            return new PathBuilderBuilder();
        }

        public static class PathBuilderBuilder {
            private ArrayList<String> paths;

            PathBuilderBuilder() {
            }

            public PathBuilderBuilder path(String path) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.add(path);
                return this;
            }

            public PathBuilderBuilder paths(Collection<? extends String> paths) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.addAll(paths);
                return this;
            }

            public PathBuilderBuilder clearPaths() {
                if (this.paths != null) {
                    this.paths.clear();
                }
                return this;
            }

            public PathBuilder build() {
                List<String> paths;
                switch (this.paths == null ? 0 : this.paths.size()) {
                    case 0: {
                        paths = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        paths = Collections.singletonList(this.paths.get(0));
                        break;
                    }
                    default: {
                        paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                    }
                }
                return new PathBuilder(paths);
            }

            public String toString() {
                return "TenantScriptStorage.PathBuilder.PathBuilderBuilder(paths=" + this.paths + ")";
            }
        }
    }

    @FunctionalInterface
    private static interface DetailsExtractor {
        public Details extract(String var1, String var2, String var3);
    }

    private static class Details {
        private final List<String> basePath;
        private final String path;

        public Details(List<String> basePath, String path) {
            this.basePath = basePath;
            this.path = path.startsWith("/") ? path.substring(1) : path;
        }

        public List<String> getBasePath() {
            return this.basePath;
        }

        public String getPath() {
            return this.path;
        }
    }
}

