/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.ScopedContext;

public final class LepContextUtils {
    public static String getTenantKey(ContextsHolder lepContextsHolder) {
        ScopedContext scopedContext = LepContextUtils.getThreadContext(lepContextsHolder);
        TenantContext tenantContext = (TenantContext)scopedContext.getValue("tenantContext", TenantContext.class);
        if (tenantContext == null) {
            throw new IllegalStateException("LEP manager thread context doesn't have value for var: tenantContext");
        }
        return TenantContextUtils.getRequiredTenantKeyValue((TenantContext)tenantContext);
    }

    private static ScopedContext getThreadContext(ContextsHolder lepContextsHolder) {
        ScopedContext scopedContext = lepContextsHolder.getContext("lep.system.thread");
        if (scopedContext == null) {
            throw new IllegalStateException("LEP manager thread context doesn't initialized. Be sure that LepManager.beginThreadContext is called");
        }
        return scopedContext;
    }

    private LepContextUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

