/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.lep.LepMethodResult;
import com.icthh.xm.commons.lep.ProceedingLep;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepManagerService;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.ScopedContext;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import com.icthh.xm.lep.groovy.GroovyScriptRunner;
import groovy.lang.Binding;
import java.util.LinkedHashMap;
import java.util.function.Supplier;

final class LepScriptUtils {
    static Object executeScript(UrlLepResourceKey scriptResourceKey, ProceedingLep proceedingLep, LepMethod method, LepManagerService managerService, Supplier<GroovyScriptRunner> resourceExecutorSupplier, LepMethodResult methodResult, Object ... overrodeArgValues) throws LepInvocationCauseException {
        GroovyScriptRunner runner = resourceExecutorSupplier.get();
        String scriptName = runner.getResourceKeyMapper().map(scriptResourceKey);
        Binding binding = LepScriptUtils.buildBinding(scriptResourceKey, managerService, method, proceedingLep, methodResult, overrodeArgValues);
        return runner.runScript(scriptResourceKey, method, managerService, scriptName, binding);
    }

    private static Binding buildBinding(UrlLepResourceKey scriptResourceKey, LepManagerService managerService, LepMethod method, ProceedingLep proceedingLep, LepMethodResult lepMethodResult, Object ... overrodeArgValues) {
        int expected;
        int actual;
        boolean isOverrodeArgs;
        boolean bl = isOverrodeArgs = overrodeArgValues != null && overrodeArgValues.length > 0;
        if (isOverrodeArgs && (actual = overrodeArgValues.length) != (expected = method.getMethodSignature().getParameterTypes().length)) {
            throw new IllegalArgumentException("When calling LEP resource: " + scriptResourceKey + ", overrode method argument values count doesn't corresponds method signature (expected: " + expected + ", actual: " + actual + ")");
        }
        LinkedHashMap<String, Object> lepContext = new LinkedHashMap<String, Object>();
        Binding binding = new Binding();
        ScopedContext executionContext = managerService.getContext("lep.system.execution");
        if (executionContext != null) {
            executionContext.getValues().forEach(lepContext::put);
        }
        String[] parameterNames = method.getMethodSignature().getParameterNames();
        Object[] methodArgValues = isOverrodeArgs ? overrodeArgValues : method.getMethodArgValues();
        LinkedHashMap<String, Object> inVars = new LinkedHashMap<String, Object>(parameterNames.length);
        for (int i = 0; i < parameterNames.length; ++i) {
            String paramName = parameterNames[i];
            Object paramValue = methodArgValues[i];
            inVars.put(paramName, paramValue);
        }
        lepContext.put("inArgs", inVars);
        lepContext.put("lep", proceedingLep);
        if (lepMethodResult != null) {
            lepContext.put("returnedValue", lepMethodResult.getReturnedValue());
        }
        lepContext.put("methodResult", lepMethodResult);
        binding.setVariable("lepContext", lepContext);
        return binding;
    }

    private LepScriptUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

