/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class RouterResourceLoader
implements ResourceLoader {
    private final Map<String, ResourceLoader> urlPrefixToResourceLoader;

    public RouterResourceLoader(Map<String, ResourceLoader> urlPrefixToResourceLoader) {
        this.urlPrefixToResourceLoader = Objects.requireNonNull(urlPrefixToResourceLoader);
    }

    public ResourceLoader getResourceLoader(String prefix) {
        return this.urlPrefixToResourceLoader.get(prefix);
    }

    private static String getUrlPrefix(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return null;
        }
        int prefixEndIndex = location.indexOf(58);
        if (prefixEndIndex <= 0) {
            return null;
        }
        return location.substring(0, prefixEndIndex + 1);
    }

    public Resource getResource(String location) {
        String urlPrefix = RouterResourceLoader.getUrlPrefix(location);
        if (urlPrefix == null) {
            throw new IllegalStateException("Can't detect URL prefix for location: " + location);
        }
        ResourceLoader resourceLoader = this.urlPrefixToResourceLoader.get(urlPrefix);
        if (resourceLoader == null) {
            throw new IllegalStateException("Unsupported resource URL prefix: " + urlPrefix);
        }
        return resourceLoader.getResource(location);
    }

    public ClassLoader getClassLoader() {
        ResourceLoader resourceLoader = this.urlPrefixToResourceLoader.get("classpath:");
        if (resourceLoader == null) {
            resourceLoader = this.urlPrefixToResourceLoader.values().stream().findFirst().orElse(null);
        }
        if (resourceLoader == null) {
            return ClassUtils.getDefaultClassLoader();
        }
        return resourceLoader.getClassLoader();
    }
}

