/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.lep.api.LepKey;
import com.icthh.xm.lep.api.LepKeyResolver;
import com.icthh.xm.lep.api.LepManagerService;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import com.icthh.xm.lep.api.commons.SeparatorSegmentedLepKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SeparatorSegmentedLepKeyResolver
implements LepKeyResolver {
    private static final int AVERAGE_PARAMETERS_COUNT = 3;
    private final Map<String, Integer> paramNameIndex = new ConcurrentHashMap<String, Integer>(3);
    private static final String INDEX_NAME_KEY_TEMPLATE = "%s:%s";

    protected static String translateToLepConvention(String xmEntitySpecKey) {
        Objects.requireNonNull(xmEntitySpecKey, "xmEntitySpecKey can't be null");
        return xmEntitySpecKey.replaceAll("-", "_").replaceAll("\\.", "\\$");
    }

    public final LepKey resolve(LepKey baseKey, LepMethod method, LepManagerService managerService) {
        Objects.requireNonNull(baseKey, "baseKey can't be null");
        if (!(baseKey instanceof SeparatorSegmentedLepKey)) {
            throw new IllegalArgumentException("Unsupported base key type: " + baseKey.getClass().getCanonicalName());
        }
        SeparatorSegmentedLepKey segmentedLepKey = (SeparatorSegmentedLepKey)SeparatorSegmentedLepKey.class.cast(baseKey);
        return this.resolveKey(segmentedLepKey, method, managerService);
    }

    protected abstract LepKey resolveKey(SeparatorSegmentedLepKey var1, LepMethod var2, LepManagerService var3);

    protected Object getParamValue(LepMethod method, String paramName) {
        int index = this.getParamIndex(method, paramName);
        return method.getMethodArgValues()[index];
    }

    protected <T> T getParamValue(LepMethod method, String paramName, Class<T> valueType) {
        Object value = this.getParamValue(method, paramName);
        return valueType.cast(value);
    }

    protected int getParamIndex(LepMethod method, String paramName) {
        Objects.requireNonNull(paramName, "paramName can't be null");
        if (paramName.isEmpty()) {
            throw new IllegalArgumentException("paramName can't be blank");
        }
        String cacheKey = this.buildParamIndexCacheKey(method, paramName);
        Integer paramIndex = this.paramNameIndex.get(cacheKey);
        if (paramIndex == null) {
            String[] parameterNames = method.getMethodSignature().getParameterNames();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!paramName.equals(parameterNames[i])) continue;
                paramIndex = i;
                this.paramNameIndex.put(cacheKey, paramIndex);
                break;
            }
        }
        if (paramIndex == null) {
            throw new IllegalStateException("Can't find parameter '" + paramName + "' for method: " + method.getMethodSignature().toString());
        }
        return paramIndex;
    }

    private String buildParamIndexCacheKey(LepMethod method, String paramName) {
        int cacheKey = method.getMethodSignature().getMethod().hashCode();
        return String.format(INDEX_NAME_KEY_TEMPLATE, cacheKey, paramName);
    }

    protected <T> T getRequiredParam(LepMethod method, String paramName, Class<T> valueType) {
        T value = this.getParamValue(method, paramName, valueType);
        if (value == null) {
            String methodDescription = this.getMethodDescription(method);
            throw new IllegalArgumentException("LEP method " + methodDescription + " required in parameter '" + paramName + "' is null");
        }
        return value;
    }

    private String getMethodDescription(LepMethod method) {
        MethodSignature methodSignature = method.getMethodSignature();
        if (methodSignature != null && methodSignature.getMethod() != null) {
            return methodSignature.getMethod().toString();
        }
        return method.toString();
    }

    protected String getRequiredStrParam(LepMethod method, String paramName) {
        return this.getRequiredParam(method, paramName, String.class);
    }

    protected String getStrParam(LepMethod method, String paramName) {
        return this.getParamValue(method, paramName, String.class);
    }
}

