/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.lep.api.Extension;
import com.icthh.xm.lep.api.ExtensionGroup;
import com.icthh.xm.lep.api.ExtensionResourceDescriptor;
import com.icthh.xm.lep.api.ExtensionService;
import com.icthh.xm.lep.api.LepKey;
import com.icthh.xm.lep.api.Version;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class XmExtensionService
implements ExtensionService {
    private static final Logger log = LoggerFactory.getLogger(XmExtensionService.class);
    private static final String[] EMPTY_GROUP_SEGMENTS = new String[0];

    public UrlLepResourceKey getResourceKey(LepKey extensionKey, Version extensionResourceVersion) {
        String extensionName;
        CharSequence[] groupSegments;
        if (extensionKey == null) {
            return null;
        }
        LepKey groupKey = extensionKey.getGroupKey();
        String extensionKeyId = extensionKey.getId();
        if (groupKey == null) {
            groupSegments = EMPTY_GROUP_SEGMENTS;
            extensionName = extensionKeyId;
        } else {
            groupSegments = groupKey.getId().split("\\.");
            extensionName = extensionKeyId.replace(groupKey.getId(), "");
            if (extensionName.startsWith(".")) {
                extensionName = extensionName.substring(".".length());
            }
        }
        String scriptName = extensionName.replaceAll("\\.", "\\$\\$");
        scriptName = StringUtils.capitalize((String)scriptName);
        Object urlPath = "/";
        if (groupSegments.length > 0) {
            urlPath = (String)urlPath + String.join((CharSequence)"/", groupSegments) + "/";
        }
        urlPath = (String)urlPath + scriptName + ".groovy";
        UrlLepResourceKey urlLepResourceKey = UrlLepResourceKey.valueOfUrlResourcePath((String)urlPath);
        if (extensionResourceVersion == null) {
            log.debug("LEP extension key: '{}' translated to --> composite resource key: '{}'", (Object)extensionKey, (Object)urlLepResourceKey);
        } else {
            log.debug("LEP extension 'key: {}, v{}' translated to --> composite resource key: '{}'", new Object[]{extensionKey, extensionResourceVersion, urlLepResourceKey});
        }
        return urlLepResourceKey;
    }

    public List<ExtensionResourceDescriptor> getExtensionResourceDescriptors() {
        throw new UnsupportedOperationException("not used yet");
    }

    public ExtensionResourceDescriptor getExtensionResourceDescriptor(LepKey extensionKey) {
        throw new UnsupportedOperationException("not used yet");
    }

    public Extension getExtension(LepKey key) {
        throw new UnsupportedOperationException("not used yet");
    }

    public List<Extension> getExtensions() {
        throw new UnsupportedOperationException("not used yet");
    }

    public List<ExtensionGroup> getExtensionGroups(Set<LepKey> groupKeys) {
        throw new UnsupportedOperationException("not used yet");
    }

    public void deleteExtension(LepKey key) {
        throw new UnsupportedOperationException("not used yet");
    }
}

