/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.config.domain.TenantAliasTree;
import java.util.Optional;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.AntPathMatcher;

public class XmFileSystemResourceLoader
implements ResourceLoader {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private static final String TENANT_PLACEHOLDER_NAME = "tenantName";
    private static final String TENANT_PLACEHOLDER = "{tenantName}";
    private static final String TENANT_PREFIX = "/config/tenants/";
    private final FileSystemResourceLoader delegate;
    private final TenantAliasService tenantAliasService;
    private final String appName;

    public Resource getResource(String location) {
        Resource resource = this.delegate.getResource(location);
        if (resource.exists() || !this.isUnderTenantFolder(location)) {
            return resource;
        }
        resource = this.tenantAliasService.getTenantAliasTree().getParents(this.extractTenantName(location)).stream().map(TenantAliasTree.TenantAlias::getKey).map(tenantKey -> this.getPathInTenant(location, (String)tenantKey)).map(arg_0 -> ((FileSystemResourceLoader)this.delegate).getResource(arg_0)).filter(Resource::exists).findFirst().orElse(resource);
        return resource;
    }

    public String getPathInTenant(String path, String targetTenant) {
        return this.getTenantName(path).map(sourceTenant -> this.replaceTenantName(path, (String)sourceTenant, targetTenant)).orElse(path);
    }

    public Optional<String> getTenantName(String path) {
        return Optional.of(path).filter(this::isUnderTenantFolder).map(this::extractTenantName);
    }

    private String replaceTenantName(String path, String sourceTenant, String targetTenant) {
        return path.replace(this.getLepPath(sourceTenant), this.getLepPath(targetTenant));
    }

    private String extractTenantName(String path) {
        return (String)this.matcher.extractUriTemplateVariables(this.lepPathPattern(), path).get(TENANT_PLACEHOLDER_NAME);
    }

    private String lepPathPattern() {
        return "**" + this.getLepPath(TENANT_PLACEHOLDER) + "**";
    }

    private String getLepPath(String tenant) {
        return TENANT_PREFIX + tenant + "/" + this.appName + "/lep/";
    }

    private boolean isUnderTenantFolder(String path) {
        return this.matcher.match(this.lepPathPattern(), path);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public XmFileSystemResourceLoader(FileSystemResourceLoader delegate, TenantAliasService tenantAliasService, String appName) {
        this.delegate = delegate;
        this.tenantAliasService = tenantAliasService;
        this.appName = appName;
    }
}

