/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.spring.LepServiceHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.type.AnnotationMetadata;

public class LepServiceFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private AnnotationMetadata annotationMetadata;
    private ApplicationContext applicationContext;
    private LepServiceHandler lepServiceHandler;
    private static final Set<String> OBJECT_METHODS = new HashSet<String>();

    public void afterPropertiesSet() throws Exception {
        this.lepServiceHandler = (LepServiceHandler)this.applicationContext.getBean(LepServiceHandler.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private static boolean isToString(Method method) {
        return "toString".equals(method.getName()) && Objects.equals(method.getReturnType(), String.class) && method.getParameterCount() == 0;
    }

    private static boolean isObjectMethod(Method method) {
        return OBJECT_METHODS.contains(method.getName());
    }

    public Object getObject() throws Exception {
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            if (LepServiceFactoryBean.isToString(method)) {
                return "LepService proxy for: " + this.getObjectType().getCanonicalName();
            }
            if (LepServiceFactoryBean.isObjectMethod(method)) {
                return method.invoke(proxy, args);
            }
            return this.lepServiceHandler.onMethodInvoke(this.type, null, method, args);
        };
        return Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, invocationHandler);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public LepServiceHandler getLepServiceHandler() {
        return this.lepServiceHandler;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    public void setLepServiceHandler(LepServiceHandler lepServiceHandler) {
        this.lepServiceHandler = lepServiceHandler;
    }

    public String toString() {
        return "LepServiceFactoryBean(type=" + this.getType() + ", annotationMetadata=" + this.getAnnotationMetadata() + ", applicationContext=" + this.getApplicationContext() + ", lepServiceHandler=" + this.getLepServiceHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LepServiceFactoryBean)) {
            return false;
        }
        LepServiceFactoryBean other = (LepServiceFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        AnnotationMetadata this$annotationMetadata = this.getAnnotationMetadata();
        AnnotationMetadata other$annotationMetadata = other.getAnnotationMetadata();
        if (this$annotationMetadata == null ? other$annotationMetadata != null : !this$annotationMetadata.equals(other$annotationMetadata)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        LepServiceHandler this$lepServiceHandler = this.getLepServiceHandler();
        LepServiceHandler other$lepServiceHandler = other.getLepServiceHandler();
        return !(this$lepServiceHandler == null ? other$lepServiceHandler != null : !this$lepServiceHandler.equals(other$lepServiceHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LepServiceFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        AnnotationMetadata $annotationMetadata = this.getAnnotationMetadata();
        result = result * 59 + ($annotationMetadata == null ? 43 : $annotationMetadata.hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        LepServiceHandler $lepServiceHandler = this.getLepServiceHandler();
        result = result * 59 + ($lepServiceHandler == null ? 43 : $lepServiceHandler.hashCode());
        return result;
    }

    static {
        OBJECT_METHODS.addAll(Arrays.asList("toString", "getClass", "hashCode", "equals", "clone", "notify", "notifyAll", "wait", "finalize"));
    }
}

