/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring;

import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEvent;
import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.internal.SpringSecurityXmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.PrivilegedTenantContext;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepProcessingEvent;
import com.icthh.xm.lep.api.ScopedContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class LepThreadHelper
implements ApplicationListener<ApplicationLepProcessingEvent> {
    private static final String THREAD = "thread";
    private final TenantContextHolder tenantContextHolder;
    private final LepManager lepManager;

    public LepThreadHelper(TenantContextHolder tenantContextHolder, LepManager lepManager) {
        this.tenantContextHolder = tenantContextHolder;
        this.lepManager = lepManager;
    }

    public <T> Future<T> runInThread(ExecutorService executorService, Callable<T> task) {
        return this.runInThread(executorService, task, SecurityContextHolder.getContext());
    }

    public <T> Future<T> runInThread(ExecutorService executorService, Callable<T> task, SecurityContext securityContext) {
        return executorService.submit(new LepThreadContext<T>(this.lepManager, task, this.tenantContextHolder, securityContext));
    }

    public void onApplicationEvent(ApplicationLepProcessingEvent event) {
        if (event.getLepProcessingEvent() instanceof LepProcessingEvent.BeforeExecutionEvent) {
            ScopedContext context = this.lepManager.getContext("lep.system.execution");
            context.setValue(THREAD, (Object)this);
        }
    }

    private static class LepThreadContext<T>
    implements Callable<T> {
        private final LepManager lepManager;
        private final Callable<T> task;
        private final Tenant tenant;
        private final TenantContext tenantContext;
        private final SecurityContext securityContext;
        private final PrivilegedTenantContext privilegedTenantContext;

        private LepThreadContext(LepManager lepManager, Callable<T> task, TenantContextHolder tenantContextHolder, SecurityContext securityContext) {
            this.lepManager = lepManager;
            this.task = task;
            this.privilegedTenantContext = tenantContextHolder.getPrivilegedContext();
            this.tenant = (Tenant)this.privilegedTenantContext.getTenant().orElseThrow(() -> new IllegalStateException("Tenant context doesn't have tenant key"));
            this.tenantContext = tenantContextHolder.getContext();
            this.securityContext = securityContext;
        }

        @Override
        public T call() {
            return (T)this.privilegedTenantContext.execute(this.tenant, this::runInLepContext);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private T runInLepContext() {
            try {
                this.init();
                T t = this.task.call();
                return t;
            }
            finally {
                this.destroy();
            }
        }

        private void init() {
            SecurityContextHolder.setContext((SecurityContext)this.securityContext);
            XmAuthenticationContext authContext = new SpringSecurityXmAuthenticationContextHolder().getContext();
            this.lepManager.beginThreadContext(threadContext -> {
                threadContext.setValue("tenantContext", (Object)this.tenantContext);
                threadContext.setValue("authContext", (Object)authContext);
            });
        }

        private void destroy() {
            this.lepManager.endThreadContext();
            SecurityContextHolder.clearContext();
        }
    }
}

