/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring.lepservice;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.XmLepScriptConfigServerResourceLoader;
import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEvent;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactory;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactoryResolver;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepProcessingEvent;
import com.icthh.xm.lep.api.ScopedContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@LepService(group="service.factory")
@Order(value=0x7FFFFFFF)
@IgnoreLogginAspect
public class LepServiceFactoryImpl
implements LepServiceFactory,
RefreshableConfiguration,
ApplicationListener<ApplicationLepProcessingEvent> {
    private static final String LEP_SERVICES = "lepServices";
    private final XmLepScriptConfigServerResourceLoader resourceLoader;
    private final TenantContextHolder tenantContextHolder;
    private final LepManager lepManager;
    private final Map<String, Map<Class<?>, Object>> serviceInstances = new ConcurrentHashMap();
    private LepServiceFactoryImpl self;

    public LepServiceFactoryImpl(XmLepScriptConfigServerResourceLoader resourceLoader, TenantContextHolder tenantContextHolder, LepManager lepManager) {
        this.resourceLoader = resourceLoader;
        this.tenantContextHolder = tenantContextHolder;
        this.lepManager = lepManager;
    }

    @Override
    public <T> T getInstance(Class<T> lepServiceClass) {
        String simpleClassName = lepServiceClass.getSimpleName();
        String tenantKey = this.tenantContextHolder.getTenantKey();
        Map tenantInstances = this.serviceInstances.computeIfAbsent(tenantKey, key -> new ConcurrentHashMap());
        return (T)tenantInstances.computeIfAbsent(lepServiceClass, key -> this.self.createServiceByLepFactory(simpleClassName, lepServiceClass));
    }

    @LogicExtensionPoint(value="ServiceFactory", resolver=LepServiceFactoryResolver.class)
    public <T> T createServiceByLepFactory(String serviceClassName, Class<T> type) {
        return this.self.createServiceByGeneratedLepFactory(serviceClassName, type);
    }

    @LogicExtensionPoint(value="GeneratedServiceFactory")
    public <T> T createServiceByGeneratedLepFactory(String serviceClassName, Class<T> type) {
        throw new RuntimeException("Error with service factory generation " + serviceClassName);
    }

    public void onApplicationEvent(ApplicationLepProcessingEvent event) {
        if (event.getLepProcessingEvent() instanceof LepProcessingEvent.BeforeExecutionEvent) {
            ScopedContext context = this.lepManager.getContext("lep.system.execution");
            context.setValue(LEP_SERVICES, (Object)this);
        }
    }

    public void refreshFinished(Collection<String> paths) {
        this.serviceInstances.clear();
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.resourceLoader.isListeningConfiguration(updatedKey);
    }

    public void onRefresh(String updatedKey, String config) {
    }

    @Autowired
    public void setSelf(LepServiceFactoryImpl self) {
        this.self = self;
    }
}

