/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.storage;

import com.icthh.xm.commons.lep.storage.TenantScriptPathResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class BaseTenantScriptPathResolver
implements TenantScriptPathResolver {
    @Override
    public String resolvePath(String tenantKey, String appName, String path) {
        Details details = this.getDetails(tenantKey, appName, path);
        return this.getScriptPath(details);
    }

    public Details getDetails(String tenantKey, String appName, String path) {
        if (path.startsWith("/commons/environment")) {
            return new Details(Arrays.asList("commons", "lep"), path.substring("/commons/environment".length()));
        }
        if (path.startsWith("/commons/tenant")) {
            return new Details(Arrays.asList(tenantKey.toUpperCase(), "commons", "lep"), path.substring("/commons/tenant".length()));
        }
        return new Details(Arrays.asList(tenantKey.toUpperCase(), appName, "lep"), path);
    }

    protected abstract String getScriptPath(Details var1);

    public static class PathBuilder {
        private final List<String> paths;

        public String[] asArray() {
            return this.paths.toArray(new String[0]);
        }

        PathBuilder(List<String> paths) {
            this.paths = paths;
        }

        public static PathBuilderBuilder builder() {
            return new PathBuilderBuilder();
        }

        public List<String> getPaths() {
            return this.paths;
        }

        public static class PathBuilderBuilder {
            private ArrayList<String> paths;

            PathBuilderBuilder() {
            }

            public PathBuilderBuilder path(String path) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.add(path);
                return this;
            }

            public PathBuilderBuilder paths(Collection<? extends String> paths) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.addAll(paths);
                return this;
            }

            public PathBuilderBuilder clearPaths() {
                if (this.paths != null) {
                    this.paths.clear();
                }
                return this;
            }

            public PathBuilder build() {
                List<String> paths;
                switch (this.paths == null ? 0 : this.paths.size()) {
                    case 0: {
                        paths = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        paths = Collections.singletonList(this.paths.get(0));
                        break;
                    }
                    default: {
                        paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                    }
                }
                return new PathBuilder(paths);
            }

            public String toString() {
                return "BaseTenantScriptPathResolver.PathBuilder.PathBuilderBuilder(paths=" + this.paths + ")";
            }
        }
    }

    public static class Details {
        private final List<String> basePath;
        private final String path;

        public Details(List<String> basePath, String path) {
            this.basePath = basePath;
            this.path = path.startsWith("/") ? path.substring(1) : path;
        }

        public List<String> getBasePath() {
            return this.basePath;
        }

        public String getPath() {
            return this.path;
        }
    }
}

