/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.storage;

import com.icthh.xm.commons.lep.TenantScriptStorage;
import com.icthh.xm.commons.lep.storage.BaseTenantScriptPathResolver;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;

public class FileTenantScriptPathResolver
extends BaseTenantScriptPathResolver {
    private final String baseDir;

    @Override
    public TenantScriptStorage resolverType() {
        return TenantScriptStorage.FILE;
    }

    @Override
    public String getScriptPath(BaseTenantScriptPathResolver.Details details) {
        String[] paths = BaseTenantScriptPathResolver.PathBuilder.builder().path("config").path("tenants").paths(details.getBasePath()).build().asArray();
        String lepDir = Paths.get(this.baseDir, paths).toString();
        String path = "/" + details.getPath();
        if (SystemUtils.IS_OS_WINDOWS) {
            return "file:///" + lepDir + FilenameUtils.separatorsToSystem((String)path);
        }
        return "file://" + lepDir + FilenameUtils.separatorsToSystem((String)path);
    }

    public FileTenantScriptPathResolver(String baseDir) {
        this.baseDir = baseDir;
    }
}

