/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.config.domain.TenantAliasTree;
import com.icthh.xm.commons.lep.GroovyFileParser;
import com.icthh.xm.commons.lep.LepContextUtils;
import com.icthh.xm.commons.lep.XmLepResourceSubType;
import com.icthh.xm.lep.api.ContextsHolder;
import com.icthh.xm.lep.api.LepResource;
import com.icthh.xm.lep.api.LepResourceKey;
import com.icthh.xm.lep.api.LepResourceService;
import com.icthh.xm.lep.api.commons.UrlLepResourceKey;
import com.icthh.xm.lep.groovy.ScriptNameLepResourceKeyMapper;
import com.icthh.xm.lep.script.InputStreamSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.StreamUtils;

public class ClassNameLepResourceKeyMapper
implements ScriptNameLepResourceKeyMapper {
    private static final String COMMONS = "commons";
    private static final String FILE_EXTENSION = ".groovy";
    private static final String LEP_SUFFIX = "$$" + XmLepResourceSubType.TENANT.getName() + ".groovy";
    private final ScriptNameLepResourceKeyMapper mapper;
    private final String appName;
    private final ContextsHolder contextsHolder;
    private final LepResourceService resourceService;
    private final TenantAliasService tenantAliasService;
    private final GroovyFileParser groovyFileParser = new GroovyFileParser();

    public String map(UrlLepResourceKey resourceKey) {
        return this.mapper.map(resourceKey);
    }

    public UrlLepResourceKey map(String name) {
        if (name == null) {
            return null;
        }
        String tenantKey = LepContextUtils.getTenantKey(this.contextsHolder);
        Optional<LepRootPath> optionalLepBasePath = this.getLepBasePath(name);
        if (optionalLepBasePath.isPresent()) {
            String path;
            LepRootPath lepBasePath = optionalLepBasePath.get();
            LepURLStreamHandler urlStreamHandler = new LepURLStreamHandler(this.contextsHolder, this.resourceService);
            String currentPath = path = lepBasePath.getPath();
            while (true) {
                String lepUrl;
                UrlLepResourceKey resourceKey;
                LepResource resource;
                if ((resource = this.resourceService.getResource(this.contextsHolder, (LepResourceKey)(resourceKey = new UrlLepResourceKey(lepUrl = currentPath + LEP_SUFFIX, (URLStreamHandler)urlStreamHandler)))) != null && this.containsClassDefinition(resource, path)) {
                    return resourceKey;
                }
                if (currentPath.lastIndexOf("$") <= 0) break;
                currentPath = currentPath.substring(0, currentPath.lastIndexOf("$"));
            }
        }
        return this.mapper.map(name);
    }

    private Optional<LepRootPath> getLepBasePath(String name) {
        if (!name.endsWith(FILE_EXTENSION)) {
            return Optional.empty();
        }
        String tenantKey = LepContextUtils.getTenantKey(this.contextsHolder);
        ArrayList<LepRootPath> rootPathVariants = new ArrayList<LepRootPath>();
        rootPathVariants.add(new LepRootPath(name, List.of(tenantKey, COMMONS, "lep"), "/commons/tenant"));
        rootPathVariants.add(new LepRootPath(name, List.of(COMMONS, "lep"), "/commons/environment"));
        ArrayList<List<String>> rootFoldersVariants = new ArrayList<List<String>>();
        rootFoldersVariants.add(List.of(tenantKey, this.appName, "lep"));
        this.tenantAliasService.getTenantAliasTree().getParents(tenantKey).stream().map(TenantAliasTree.TenantAlias::getKey).map((? super T tenant) -> List.of(tenant, this.appName, "lep")).forEach(rootFoldersVariants::add);
        rootFoldersVariants.stream().map((? super T it) -> new LepRootPath(name, (List<String>)it)).forEach(rootPathVariants::add);
        return rootPathVariants.stream().filter(LepRootPath::isMatch).findFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsClassDefinition(LepResource resource, String path) {
        boolean bl;
        if (!(resource instanceof InputStreamSupplier)) return false;
        String className = path;
        if (path.lastIndexOf("$") > 0) {
            className = path.substring(path.lastIndexOf("$") + 1);
        } else if (path.lastIndexOf("/") > 0) {
            className = path.substring(path.lastIndexOf("/") + 1);
        }
        try (InputStream inputStream = ((InputStreamSupplier)resource).getInputStream();){
            String content = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            bl = this.groovyFileParser.isFileContainsClassDefinition(content, className);
            if (inputStream == null) return bl;
        }
        return bl;
    }

    public ClassNameLepResourceKeyMapper(ScriptNameLepResourceKeyMapper mapper, String appName, ContextsHolder contextsHolder, LepResourceService resourceService, TenantAliasService tenantAliasService) {
        this.mapper = mapper;
        this.appName = appName;
        this.contextsHolder = contextsHolder;
        this.resourceService = resourceService;
        this.tenantAliasService = tenantAliasService;
    }

    static class LepURLConnection
    extends URLConnection {
        private final URL url;
        private final ContextsHolder contextsHolder;
        private final LepResourceService resourceService;

        LepURLConnection(URL url, ContextsHolder contextsHolder, LepResourceService resourceService) {
            super(url);
            this.url = url;
            this.contextsHolder = contextsHolder;
            this.resourceService = resourceService;
        }

        @Override
        public void connect() throws IOException {
            throw new IOException("Cannot connect to " + this.url);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            LepResource resource = this.resourceService.getResource(this.contextsHolder, (LepResourceKey)new UrlLepResourceKey(this.url.toString()));
            if (resource instanceof InputStreamSupplier) {
                return ((InputStreamSupplier)resource).getInputStream();
            }
            return super.getInputStream();
        }
    }

    static class LepURLStreamHandler
    extends URLStreamHandler {
        private final ContextsHolder contextsHolder;
        private final LepResourceService resourceService;

        @Override
        protected URLConnection openConnection(URL url) {
            return new LepURLConnection(url, this.contextsHolder, this.resourceService);
        }

        public LepURLStreamHandler(ContextsHolder contextsHolder, LepResourceService resourceService) {
            this.contextsHolder = contextsHolder;
            this.resourceService = resourceService;
        }
    }

    static class LepRootPath {
        private final String name;
        private final String rootPath;
        private final String prefix;

        LepRootPath(String name, List<String> rootPath) {
            this.name = name;
            this.rootPath = String.join((CharSequence)"/", rootPath);
            this.prefix = "lep://" + rootPath.get(0);
        }

        LepRootPath(String name, List<String> rootPath, String prefix) {
            this.name = name;
            this.rootPath = String.join((CharSequence)"/", rootPath);
            this.prefix = "lep://" + prefix;
        }

        public String getPath() {
            return this.prefix + this.name.substring(this.rootPath.length(), this.name.length() - ClassNameLepResourceKeyMapper.FILE_EXTENSION.length());
        }

        public boolean isMatch() {
            return this.name.startsWith(this.rootPath);
        }
    }
}

