/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import groovyjarjarantlr.CharScanner;
import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import groovyjarjarantlr.collections.AST;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.antlr.treewalker.Visitor;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyFileParser {
    private static final Logger log = LoggerFactory.getLogger(GroovyFileParser.class);

    public boolean isFileContainsClassDefinition(String source, final String className) {
        try {
            final MutableBoolean isExistsDef = new MutableBoolean(false);
            this.parseGroovy(source, (Visitor)new VisitorAdapter(){

                public void visitClassDef(GroovySourceAST t, int visit) {
                    this.visitDef(t, className, isExistsDef);
                }

                public void visitInterfaceDef(GroovySourceAST t, int visit) {
                    this.visitDef(t, className, isExistsDef);
                }

                public void visitEnumDef(GroovySourceAST t, int visit) {
                    this.visitDef(t, className, isExistsDef);
                }

                public void visitAnnotationDef(GroovySourceAST t, int visit) {
                    this.visitDef(t, className, isExistsDef);
                }

                private void visitDef(GroovySourceAST t, String className2, MutableBoolean isExistsDef2) {
                    boolean isClassDefPresent = className2.equals(t.childOfType(87).getText());
                    isExistsDef2.setValue(isExistsDef2.booleanValue() || isClassDefPresent);
                }
            });
            return isExistsDef.getValue();
        }
        catch (Exception e) {
            log.error("Error parse groovy", (Throwable)e);
            return false;
        }
    }

    public void parseGroovy(String source, Visitor visitor) throws TokenStreamException, RecognitionException, IOException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        GroovyRecognizer parser = GroovyFileParser.getGroovyParser(source, sourceBuffer);
        parser.compilationUnit();
        AST ast = parser.getAST();
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
    }

    private static GroovyRecognizer getGroovyParser(String input, SourceBuffer sourceBuffer) throws IOException {
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader((Reader)new StringReader(input), sourceBuffer);
        GroovyLexer lexer = new GroovyLexer((Reader)unicodeReader);
        unicodeReader.setLexer((CharScanner)lexer);
        GroovyRecognizer parser = GroovyRecognizer.make((GroovyLexer)lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }
}

