/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.lep.api.LepExecutorEvent;
import com.icthh.xm.lep.api.LepExecutorListener;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmLepLoggingExecutorListener
implements LepExecutorListener {
    private static final Logger log = LoggerFactory.getLogger(XmLepLoggingExecutorListener.class);
    private static final String LOG_QUESTION = "?";
    private static final String LOG_SEMICOLON = ":";
    private static final String LOG_START_PATTERN = "lep:start: execute lep at [{}], script: {}";
    private static final String LOG_STOP_PATTERN = "lep:stop:  execute lep at [{}], script: {}";
    private static final String LOG_ERROR_PATTERN = "lep:stop:  execute lep error at [{}], script: {}, error: {}";
    private final LoggingConfigService loggingConfigService;

    public XmLepLoggingExecutorListener(LoggingConfigService loggingConfigService) {
        this.loggingConfigService = loggingConfigService;
    }

    public void accept(LepExecutorEvent lepExecutorEvent) {
        if (lepExecutorEvent instanceof LepExecutorEvent.BeforeResourceExecutionEvent) {
            this.onBeforeEvent((LepExecutorEvent.BeforeResourceExecutionEvent)lepExecutorEvent);
        } else if (lepExecutorEvent instanceof LepExecutorEvent.AfterResourceExecutionEvent) {
            this.onAfterEvent((LepExecutorEvent.AfterResourceExecutionEvent)lepExecutorEvent);
        }
    }

    private void onBeforeEvent(LepExecutorEvent.BeforeResourceExecutionEvent beforeEvent) {
        LoggingConfig.LepLogConfiguration loggingConfig = this.loggingConfigService.getLepLoggingConfig(beforeEvent.getKey().getId());
        if (loggingConfig == null) {
            log.info(LOG_START_PATTERN, (Object)XmLepLoggingExecutorListener.buildLepSignature(beforeEvent.getMethod()), (Object)beforeEvent.getKey());
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)loggingConfig.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)loggingConfig.getLevel(), (String)LOG_START_PATTERN, (Object[])new Object[]{XmLepLoggingExecutorListener.buildLepSignature(beforeEvent.getMethod()), beforeEvent.getKey()});
    }

    private void onAfterEvent(LepExecutorEvent.AfterResourceExecutionEvent afterEvent) {
        String signatureToPrint = XmLepLoggingExecutorListener.buildLepSignature(afterEvent.getMethod());
        String scriptName = afterEvent.getKey().getId();
        Optional exception = afterEvent.getResult().flatMap(LepExecutorEvent.ResultObject::getException);
        if (exception.isPresent()) {
            this.logStopError(signatureToPrint, scriptName, (Exception)exception.get());
        } else {
            LoggingConfig.LepLogConfiguration loggingConfig = this.loggingConfigService.getLepLoggingConfig(scriptName);
            this.logStop(signatureToPrint, scriptName, loggingConfig);
        }
    }

    private void logStop(String signature, String scriptName, LoggingConfig.LepLogConfiguration config) {
        if (config == null) {
            log.info(LOG_STOP_PATTERN, (Object)signature, (Object)scriptName);
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel((Logger)log, (LogObjectPrinter.Level)config.getLevel(), (String)LOG_STOP_PATTERN, (Object[])new Object[]{signature, scriptName});
    }

    private void logStopError(String signature, String scriptName, Exception e) {
        log.error(LOG_ERROR_PATTERN, new Object[]{signature, scriptName, LogObjectPrinter.printExceptionWithStackInfo((Throwable)e)});
    }

    private static String buildLepSignature(LepMethod method) {
        String className = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getDeclaringClass).map(Class::getSimpleName).orElse(LOG_QUESTION);
        String methodName = Optional.ofNullable(method).map(LepMethod::getMethodSignature).map(MethodSignature::getName).orElse(LOG_QUESTION);
        return className + LOG_SEMICOLON + methodName;
    }
}

