/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Objects;
import org.springframework.core.io.AbstractResource;

public class XmLepScriptResource
extends AbstractResource {
    private static final XmLepScriptResource NON_EXIST = new XmLepScriptResource("-none-");
    private final String xmMsConfigPath;
    private long lastModified;
    private String content;
    private boolean exists;

    public static XmLepScriptResource nonExist() {
        return NON_EXIST;
    }

    public XmLepScriptResource(String xmMsConfigPath) {
        this.xmMsConfigPath = Objects.requireNonNull(xmMsConfigPath, "xmMsConfigPath can't be null");
        this.exists = false;
        this.lastModified = 0L;
    }

    public XmLepScriptResource(String xmMsConfigPath, long lastModified) {
        this.xmMsConfigPath = Objects.requireNonNull(xmMsConfigPath, "xmMsConfigPath can't be null");
        this.exists = false;
        this.lastModified = lastModified;
    }

    public XmLepScriptResource(String xmMsConfigPath, String content, long lastModified) {
        this.xmMsConfigPath = Objects.requireNonNull(xmMsConfigPath, "xmMsConfigPath can't be null");
        this.content = Objects.requireNonNull(content, "content can't be null");
        this.lastModified = lastModified;
        this.exists = true;
    }

    public void update(String content, long lastModified) {
        if (!this.exists) {
            throw new IllegalStateException("Can't update content for not existing resource, location: " + this.xmMsConfigPath + ". Create new " + XmLepScriptResource.class.getSimpleName() + " instance for this");
        }
        this.content = Objects.requireNonNull(content, "content can't be null");
        this.lastModified = lastModified;
    }

    public boolean exists() {
        return this.exists;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void modifiedNow() {
        this.lastModified = Instant.now().toEpochMilli();
    }

    public String getDescription() {
        return this.xmMsConfigPath;
    }

    public InputStream getInputStream() throws IOException {
        if (this.content == null) {
            throw new IOException("Content is null");
        }
        return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8.name()));
    }
}

