/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.spring.lepservice;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.XmLepScriptConfigServerResourceLoader;
import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEvent;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactory;
import com.icthh.xm.commons.lep.spring.lepservice.LepServiceFactoryResolver;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepProcessingEvent;
import com.icthh.xm.lep.api.ScopedContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@LepService(group="service.factory")
@Order(value=0x7FFFFFFF)
@IgnoreLogginAspect
public class LepServiceFactoryImpl
implements LepServiceFactory,
RefreshableConfiguration,
ApplicationListener<ApplicationLepProcessingEvent> {
    private static final Logger log = LoggerFactory.getLogger(LepServiceFactoryImpl.class);
    private static final String LEP_SERVICES = "lepServices";
    private final XmLepScriptConfigServerResourceLoader resourceLoader;
    private final TenantContextHolder tenantContextHolder;
    private final LepManager lepManager;
    private final Integer timeout;
    private final Map<String, Map<Class<?>, Object>> serviceInstances = new ConcurrentHashMap();
    private final Map<String, Map<Class<?>, Lock>> serviceLocks = new ConcurrentHashMap();
    private LepServiceFactoryImpl self;

    public LepServiceFactoryImpl(XmLepScriptConfigServerResourceLoader resourceLoader, TenantContextHolder tenantContextHolder, LepManager lepManager, @Value(value="${application.lep.service-factory-timeout:60}") Integer timeout) {
        this.resourceLoader = resourceLoader;
        this.tenantContextHolder = tenantContextHolder;
        this.lepManager = lepManager;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInstance(Class<T> lepServiceClass) {
        String simpleClassName = lepServiceClass.getSimpleName();
        String tenantKey = this.tenantContextHolder.getTenantKey();
        Map tenantInstances = this.serviceInstances.computeIfAbsent(tenantKey, key -> new ConcurrentHashMap());
        Object instance = tenantInstances.get(lepServiceClass);
        if (instance != null) {
            return (T)instance;
        }
        Map tenantServiceFactoryLocks = this.serviceLocks.computeIfAbsent(tenantKey, key -> new ConcurrentHashMap());
        Lock lock = tenantServiceFactoryLocks.computeIfAbsent(lepServiceClass, key -> new ReentrantLock());
        log.trace("Try to acquired lock for service {}", (Object)lepServiceClass.getCanonicalName());
        StopWatch stopWatch = StopWatch.createStarted();
        if (!lock.tryLock(this.timeout.intValue(), TimeUnit.SECONDS)) {
            throw new IllegalStateException(String.format("Timeout waiting service factory for service %s.", lepServiceClass.getCanonicalName()));
        }
        try {
            log.trace("Successfully acquired lock for service {} in {}ns", (Object)lepServiceClass.getSimpleName(), (Object)stopWatch.getNanoTime());
            instance = tenantInstances.get(lepServiceClass);
            if (instance != null) {
                Object v = instance;
                return (T)v;
            }
            T newInstance = this.self.createServiceByLepFactory(simpleClassName, lepServiceClass);
            tenantInstances.put(lepServiceClass, newInstance);
            T t = newInstance;
            return t;
        }
        finally {
            lock.unlock();
            log.trace("Lock for service {} successfully released in {}ns", (Object)lepServiceClass.getSimpleName(), (Object)stopWatch.getNanoTime());
            tenantServiceFactoryLocks.remove(lepServiceClass);
        }
    }

    @LogicExtensionPoint(value="ServiceFactory", resolver=LepServiceFactoryResolver.class)
    public <T> T createServiceByLepFactory(String serviceClassName, Class<T> type) {
        return this.self.createServiceByGeneratedLepFactory(serviceClassName, type);
    }

    @LogicExtensionPoint(value="GeneratedServiceFactory")
    public <T> T createServiceByGeneratedLepFactory(String serviceClassName, Class<T> type) {
        throw new RuntimeException("Error with service factory generation " + serviceClassName);
    }

    public void onApplicationEvent(ApplicationLepProcessingEvent event) {
        if (event.getLepProcessingEvent() instanceof LepProcessingEvent.BeforeExecutionEvent) {
            ScopedContext context = this.lepManager.getContext("lep.system.execution");
            context.setValue(LEP_SERVICES, (Object)this);
        }
    }

    public void refreshFinished(Collection<String> paths) {
        this.serviceInstances.clear();
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.resourceLoader.isListeningConfiguration(updatedKey);
    }

    public void onRefresh(String updatedKey, String config) {
    }

    @Autowired
    public void setSelf(LepServiceFactoryImpl self) {
        this.self = self;
    }
}

