/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep;

import com.icthh.xm.commons.config.client.service.TenantAliasService;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.spring.ApplicationNameProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;

public class LepPathResolver {
    public static final String URL_PREFIX_COMMONS_ENVIRONMENT = "commons/environment";
    public static final String URL_PREFIX_COMMONS_TENANT = "commons/tenant";
    private static final String TENANT_NAME = "tenantKey";
    public static final String ENV_COMMONS = "commons";
    private final String appName;
    private final TenantAliasService tenantAliasService;
    private final List<LepPath> baseLepPaths;
    private final List<LepPath> reversedBaseLepPaths;

    public LepPathResolver(ApplicationNameProvider applicationNameProvider, TenantAliasService tenantAliasService) {
        this.appName = applicationNameProvider.getAppName();
        this.tenantAliasService = tenantAliasService;
        this.baseLepPaths = this.buildLepPaths();
        this.reversedBaseLepPaths = new ArrayList<LepPath>(this.baseLepPaths);
        Collections.reverse(this.reversedBaseLepPaths);
    }

    private List<LepPath> buildLepPaths() {
        return List.of(new LepPath("/config/tenants/{tenantKey}/" + this.appName + "/lep/**", tenant -> tenant + "/" + this.appName + "/lep", "", "/commons/"), new LepPath("/config/tenants/{tenantKey}/commons/lep/**", tenant -> tenant + "/commons/lep", URL_PREFIX_COMMONS_TENANT, "/"), new LepPath("/config/tenants/commons/lep/**", tenant -> "commons/lep", URL_PREFIX_COMMONS_ENVIRONMENT, "/"));
    }

    public String getTenantFromPath(String path) {
        return this.baseLepPaths.stream().filter(it -> it.isMatchPatter(path)).map(it -> it.getPathVariable(path, TENANT_NAME)).filter(Objects::nonNull).findAny().orElse(ENV_COMMONS);
    }

    public List<String> getLepBasePaths(String tenant) {
        ArrayList<String> tenantKeys = new ArrayList<String>();
        tenantKeys.add(tenant);
        tenantKeys.addAll(this.tenantAliasService.getTenantAliasTree().getParentKeys(tenant));
        return tenantKeys.stream().flatMap(tenantKey -> this.baseLepPaths.stream().map(it -> it.lepFolderPrefix.apply((String)tenantKey))).collect(Collectors.toList());
    }

    public String getLepPath(LepKey lepKey, String tenant) {
        return this.buildLepPath(lepKey, tenant, Function.identity());
    }

    public String getLegacyLepPath(LepKey lepKey, String tenant) {
        return this.buildLepPath(lepKey, tenant, LepPathResolver::translateToLepConvention);
    }

    private static String translateToLepConvention(String xmEntitySpecKey) {
        return xmEntitySpecKey.replaceAll("-", "_").replaceAll("\\.", "\\$");
    }

    private String buildLepPath(LepKey lepKey, String tenant, Function<String, String> segmentMapper) {
        Object lepPath = lepKey.getBaseKey();
        List<String> segments = lepKey.getSegments();
        if (StringUtils.isNotBlank((CharSequence)lepKey.getGroup())) {
            lepPath = lepKey.getGroup().replace(".", "/") + "/" + lepKey.getBaseKey();
        }
        if (CollectionUtils.isNotEmpty(segments)) {
            segments = segments.stream().map(segmentMapper).collect(Collectors.toList());
            lepPath = (String)lepPath + "$$" + StringUtils.join(segments, (String)"$$");
        }
        String relativeLepPath = lepPath;
        return this.reversedBaseLepPaths.stream().filter(it -> it.isMatchPrefix(relativeLepPath)).map(it -> it.buildAbsoluteLepPath(tenant, relativeLepPath)).findFirst().get();
    }

    public List<String> getLepCommonsPaths(String tenant) {
        return this.baseLepPaths.stream().map(it -> it.getCommonsPath(tenant)).collect(Collectors.toList());
    }

    public List<String> getLepPathPatterns() {
        return this.baseLepPaths.stream().map(LepPath::getLepFolderAntPattern).collect(Collectors.toList());
    }

    public List<LepRootPath> getLepPathVariants(String tenantKey) {
        List parentKeys = this.tenantAliasService.getTenantAliasTree().getParentKeys(tenantKey);
        return this.baseLepPaths.stream().flatMap(it -> it.buildLepRootPaths(tenantKey, parentKeys).stream()).collect(Collectors.toList());
    }

    public static class LepRootPath {
        private final String prefix;
        private final String rootPath;

        public String getPath(String name) {
            return this.rootPath + name.substring(this.prefix.length());
        }

        public boolean isMatch(String name) {
            return name.startsWith(this.prefix);
        }

        public String toString() {
            return "LepPathResolver.LepRootPath(prefix=" + this.prefix + ", rootPath=" + this.rootPath + ")";
        }

        public LepRootPath(String prefix, String rootPath) {
            this.prefix = prefix;
            this.rootPath = rootPath;
        }
    }

    public static class LepPath {
        private final String lepFolderAntPattern;
        private final Function<String, String> lepFolderPrefix;
        private final String lepPrefix;
        private final String relativeCommonsFolderPath;
        private final AntPathMatcher pathMatcher = new AntPathMatcher();

        public String getCommonsPath(String tenant) {
            return this.lepFolderPrefix.apply(tenant) + this.relativeCommonsFolderPath;
        }

        public boolean isMatchPatter(String path) {
            return this.pathMatcher.match(this.lepFolderAntPattern, path);
        }

        public String getPathVariable(String path, String variable) {
            return (String)this.pathMatcher.extractUriTemplateVariables(this.lepFolderAntPattern, path).get(variable);
        }

        public boolean isMatchPrefix(String lepPath) {
            return lepPath.startsWith(this.lepPrefix);
        }

        public String buildAbsoluteLepPath(String tenant, String relativeLepPath) {
            Object lepPath = relativeLepPath.substring(this.lepPrefix.length());
            if (!((String)lepPath).startsWith("/")) {
                lepPath = "/" + (String)lepPath;
            }
            return this.lepFolderPrefix.apply(tenant) + (String)lepPath;
        }

        public List<LepRootPath> buildLepRootPaths(String tenantKey, List<String> parentTenants) {
            ArrayList<LepRootPath> result = new ArrayList<LepRootPath>();
            result.add(new LepRootPath(this.lepFolderPrefix.apply(tenantKey), this.lepFolderPrefix.apply(tenantKey)));
            if (StringUtils.isNotBlank((CharSequence)this.lepPrefix)) {
                result.add(new LepRootPath(this.lepPrefix, this.lepFolderPrefix.apply(tenantKey)));
            }
            for (String parentTenant : parentTenants) {
                LepRootPath lepRootPath = new LepRootPath(this.lepFolderPrefix.apply(parentTenant), this.lepFolderPrefix.apply(tenantKey));
                result.add(lepRootPath);
            }
            return result;
        }

        public LepPath(String lepFolderAntPattern, Function<String, String> lepFolderPrefix, String lepPrefix, String relativeCommonsFolderPath) {
            this.lepFolderAntPattern = lepFolderAntPattern;
            this.lepFolderPrefix = lepFolderPrefix;
            this.lepPrefix = lepPrefix;
            this.relativeCommonsFolderPath = relativeCommonsFolderPath;
        }

        public String getLepFolderAntPattern() {
            return this.lepFolderAntPattern;
        }
    }
}

