/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl;

import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.impl.LogicExtensionPointHandler;
import com.icthh.xm.commons.lep.spring.LepService;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class LepMethodAspect {
    @Autowired
    private LogicExtensionPointHandler handler;

    @Around(value="@annotation(com.icthh.xm.commons.lep.LogicExtensionPoint)")
    public Object logicExtensionPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class declaringType = signature.getDeclaringType();
        if (!declaringType.isAnnotationPresent(LepService.class)) {
            throw new IllegalStateException("Bean class " + declaringType + " has no LepService annotation, but have LogicExtensionPoint annotation on method: " + signature);
        }
        Method method = signature.getMethod();
        LogicExtensionPoint lep = method.getAnnotation(LogicExtensionPoint.class);
        Object resultValue = lep == null ? joinPoint.proceed() : this.handler.handleLepMethod(declaringType, joinPoint.getTarget(), method, lep, joinPoint.getArgs());
        return resultValue;
    }
}

