/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl;

import com.icthh.xm.commons.lep.LogicExtensionPoint;
import com.icthh.xm.commons.lep.TargetProceedingLep;
import com.icthh.xm.commons.lep.api.BaseLepContext;
import com.icthh.xm.commons.lep.api.LepEngine;
import com.icthh.xm.commons.lep.api.LepExecutor;
import com.icthh.xm.commons.lep.api.LepKey;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.lep.impl.DefaultLepKey;
import com.icthh.xm.commons.lep.impl.LepMethodImpl;
import com.icthh.xm.commons.lep.impl.MethodEqualsByReferenceWrapper;
import com.icthh.xm.commons.lep.impl.MethodSignatureImpl;
import com.icthh.xm.commons.lep.spring.LepContextService;
import com.icthh.xm.commons.lep.spring.LepService;
import com.icthh.xm.lep.api.LepInvocationCauseException;
import com.icthh.xm.lep.api.LepKeyResolver;
import com.icthh.xm.lep.api.LepMethod;
import com.icthh.xm.lep.api.MethodSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicExtensionPointHandler {
    private static final Logger log = LoggerFactory.getLogger(LogicExtensionPointHandler.class);
    private final Map<MethodEqualsByReferenceWrapper, MethodSignature> methodsCache = new ConcurrentHashMap<MethodEqualsByReferenceWrapper, MethodSignature>();
    private final Map<Class<? extends LepKeyResolver>, LepKeyResolver> resolvers;
    private final LepManagementService lepEngineService;
    private final LepContextService lepContextService;

    public LogicExtensionPointHandler(List<LepKeyResolver> resolverList, LepManagementService lepEngineService, LepContextService lepContextService) {
        HashMap resolvers = new HashMap();
        resolverList.forEach(it -> resolvers.put(it.getClass(), it));
        this.resolvers = Collections.unmodifiableMap(resolvers);
        this.lepEngineService = lepEngineService;
        this.lepContextService = lepContextService;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object handleLepMethod(Class<?> targetType, Object target, Method method, LogicExtensionPoint lep, Object[] args) {
        try {
            LepService typeLepService = targetType.getAnnotation(LepService.class);
            Objects.requireNonNull(typeLepService, () -> "No " + LepService.class.getSimpleName() + " annotation for type " + targetType.getCanonicalName());
            String group = StringUtils.isNotBlank((CharSequence)lep.group()) ? lep.group() : typeLepService.group();
            DefaultLepKey baseLepKey = new DefaultLepKey(group, lep.value());
            MethodSignature methodSignature = this.buildMethodSignature(targetType, method);
            LepMethodImpl lepMethod = new LepMethodImpl(target, methodSignature, args, baseLepKey);
            LepKey lepKey = this.resolveLepKey(lep, baseLepKey, lepMethod);
            LepExecutor lepEngine = this.lepEngineService.getLepExecutor(lepKey);
            return lepEngine.ifLepPresent(engine -> this.invokeLepMethod((LepEngine)engine, target, lepMethod, lepKey)).ifLepNotExists(() -> this.invokeOriginalMethod(target, lepMethod, lepKey)).getMethodResult();
        }
        catch (LepInvocationCauseException e) {
            log.error("Error process lep", (Throwable)e);
            throw e.getCause();
            catch (Throwable e2) {
                log.error("Error process lep", e2);
                throw e2;
            }
        }
    }

    private Object invokeLepMethod(LepEngine lepEngine, Object target, LepMethod lepMethod, LepKey lepKey) {
        TargetProceedingLep targetProceedingLep = new TargetProceedingLep(target, lepMethod, lepKey);
        BaseLepContext lepContext = this.buildLepContext(lepEngine, lepMethod, targetProceedingLep);
        return lepEngine.invoke(lepKey, targetProceedingLep, lepContext);
    }

    private BaseLepContext buildLepContext(LepEngine lepEngine, LepMethod lepMethod, TargetProceedingLep targetProceedingLep) {
        String lepContextMethodParameter = lepMethod.getMethodSignature().getLepContextMethodParameter();
        if (lepContextMethodParameter == null) {
            return this.lepContextService.createLepContext(lepEngine, targetProceedingLep);
        }
        return lepMethod.getParameter(lepContextMethodParameter, BaseLepContext.class);
    }

    private Object invokeOriginalMethod(Object target, LepMethod lepMethod, LepKey lepKey) {
        Method method = lepMethod.getMethodSignature().getMethod();
        try {
            return method.invoke(target, lepMethod.getMethodArgValues());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while processing target method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IllegalStateException("Invocation exception cause is null, while processing target method for LEP resource key: " + lepKey);
            }
            if (cause instanceof Error) {
                throw (Error)Error.class.cast(cause);
            }
            if (cause instanceof Exception) {
                throw (Exception)Exception.class.cast(cause);
            }
            log.warn("Error execute LEP target method", (Throwable)e);
            throw new IllegalStateException("Error processing target method for LEP resource key: " + lepKey + ". " + cause.getMessage(), cause);
        }
    }

    private LepKey resolveLepKey(LogicExtensionPoint lep, LepKey baseLepKey, LepMethod lepMethod) {
        LepKeyResolver keyResolver = this.getResolver(lep);
        return new DefaultLepKey(keyResolver.group(lepMethod), baseLepKey.getBaseKey(), keyResolver.segments(lepMethod));
    }

    private LepKeyResolver getResolver(LogicExtensionPoint lep) {
        LepKeyResolver lepKeyResolver = this.resolvers.get(lep.resolver());
        Objects.requireNonNull(lepKeyResolver, () -> "Lep key resolver " + lep.resolver().getCanonicalName() + " must be spring bean");
        return lepKeyResolver;
    }

    private MethodSignature buildMethodSignature(Class<?> targetType, Method method) {
        return this.methodsCache.computeIfAbsent(MethodEqualsByReferenceWrapper.wrap(method), wrapper -> new MethodSignatureImpl(wrapper.getMethod(), targetType));
    }
}

