/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.impl.utils;

import com.icthh.xm.commons.lep.api.XmLepConfigFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ClassPathLepRepository {
    private final ResourceLoader resourceLoader;

    public Map<String, XmLepConfigFile> getLepFilesFromResources(String folderName) {
        Set<String> defaultLeps = this.getResourceFiles(folderName);
        HashMap<String, XmLepConfigFile> defauleLepsMap = new HashMap<String, XmLepConfigFile>();
        for (String fileName : defaultLeps) {
            Resource resource = this.resourceLoader.getResource("classpath:" + fileName);
            String relativePath = fileName.substring(folderName.length());
            defauleLepsMap.put(relativePath, new XmLepConfigFile(relativePath, (InputStreamSource)resource));
        }
        return defauleLepsMap;
    }

    private Set<String> getResourceFiles(String folderName) {
        Reflections reflections = new Reflections(folderName, new Scanner[]{new ResourcesScanner()});
        return reflections.getResources(x -> true);
    }

    public ClassPathLepRepository(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

