/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.lep.api;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;

public class XmLepConfigFile {
    private final String path;
    private final InputStreamSource contentStream;
    private final long lastModified = Instant.now().toEpochMilli();

    public XmLepConfigFile(String path, InputStreamSource content) {
        this.path = path;
        this.contentStream = content;
    }

    public XmLepConfigFile(String path, String content) {
        this(path, (InputStreamSource)new ByteArrayResource(content.getBytes(StandardCharsets.UTF_8)));
    }

    public String readContent() {
        return IOUtils.toString((InputStream)this.contentStream.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public String metadataKey() {
        return this.path + ":" + this.lastModified;
    }

    public String getPath() {
        return this.path;
    }

    public InputStreamSource getContentStream() {
        return this.contentStream;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        return "XmLepConfigFile(path=" + this.getPath() + ", lastModified=" + this.getLastModified() + ")";
    }
}

